/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance(PsiReferenceRegistrarImpl.class);
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = new THashMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = new THashMap();
    private final ConcurrentMap<Class<?>, ProviderBinding[]> myBindingCache;
    private boolean myInitialized;
    private final List<Disposable> myCleanupDisposables = new ArrayList<Disposable>();

    PsiReferenceRegistrarImpl() {
        this.myBindingCache = ConcurrentFactoryMap.createMap(key -> {
            SmartList result2 = new SmartList();
            for (Class<?> bindingClass : this.myBindingsMap.keySet()) {
                if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
                result2.add(this.myBindingsMap.get(bindingClass));
            }
            for (Class<?> bindingClass : this.myNamedBindingsMap.keySet()) {
                if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
                result2.add(this.myNamedBindingsMap.get(bindingClass));
            }
            return result2.toArray(new ProviderBinding[0]);
        });
    }

    void markInitialized() {
        this.myInitialized = true;
    }

    void cleanup() {
        for (Disposable disposable2 : new ArrayList<Disposable>(this.myCleanupDisposables)) {
            Disposer.dispose((Disposable)disposable2);
        }
        this.myCleanupDisposables.clear();
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        this.registerReferenceProvider(pattern, provider, priority, null);
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, final @NotNull PsiReferenceProvider provider, double priority, @Nullable Disposable parentDisposable) {
        SimpleProviderBinding providerBinding;
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode() && parentDisposable == null) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        final Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List conditions = pattern.getCondition().getConditions();
        for (PatternCondition _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtilRt.toStringArray((Collection)strings), nameCondition, scope, true, provider, priority, pattern, parentDisposable);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern, parentDisposable);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
        if (parentDisposable != null) {
            Disposable disposable2 = new Disposable(){

                public void dispose() {
                    PsiReferenceRegistrarImpl.this.unregisterReferenceProvider(scope, provider);
                    PsiReferenceRegistrarImpl.this.myCleanupDisposables.remove(this);
                }
            };
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable2);
            this.myCleanupDisposables.add(disposable2);
        }
        this.clearBindingsCache();
    }

    void clearBindingsCache() {
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class<?> scope, @NotNull PsiReferenceProvider provider) {
        SimpleProviderBinding binding = this.myBindingsMap.get(scope);
        if (binding != null) {
            binding.unregisterProvider(provider);
            if (binding.isEmpty()) {
                this.myBindingsMap.remove(scope);
            }
        }
        this.clearBindingsCache();
    }

    private void registerNamedReferenceProvider(String @NotNull [] names2, final PsiNamePatternCondition<?> nameCondition, final @NotNull Class<?> scopeClass, boolean caseSensitive, final @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern<?> pattern, @Nullable Disposable parentDisposable) {
        NamedObjectProviderBinding providerBinding = this.myNamedBindingsMap.get(scopeClass);
        if (providerBinding == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    return nameCondition.getPropertyValue((Object)position);
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names2, pattern, caseSensitive, provider, priority);
        if (parentDisposable != null) {
            final NamedObjectProviderBinding finalProviderBinding = providerBinding;
            Disposable disposable2 = new Disposable(){

                public void dispose() {
                    finalProviderBinding.unregisterProvider(provider);
                    if (finalProviderBinding.isEmpty()) {
                        PsiReferenceRegistrarImpl.this.myNamedBindingsMap.remove(scopeClass);
                    }
                    PsiReferenceRegistrarImpl.this.myCleanupDisposables.remove(this);
                }
            };
            this.myCleanupDisposables.add(disposable2);
            Disposer.register((Disposable)parentDisposable, (Disposable)disposable2);
        }
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints2) {
        ProviderBinding[] bindings = (ProviderBinding[])this.myBindingCache.get(element2.getClass());
        if (bindings.length == 0) {
            return Collections.emptyList();
        }
        SmartList ret = new SmartList();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element2, (List<? super ProviderBinding.ProviderInfo<ProcessingContext>>)ret, hints2);
        }
        return ret;
    }
}

