/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.ImportSchemeChooserDialog;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSettingsLoader;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeXmlImporter
extends CodeStyleSettingsLoader
implements SchemeImporter<CodeStyleScheme> {
    public String @NotNull [] getSourceExtensions() {
        return new String[]{"xml"};
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<CodeStyleScheme> schemeFactory) throws SchemeImportException {
        Pair<String, CodeStyleScheme> importPair;
        Element rootElement = SchemeImportUtil.loadSchemeDom(selectedFile);
        Element schemeRoot = CodeStyleSchemeXmlImporter.findSchemeRoot(rootElement);
        Pair<String, CodeStyleScheme> pair = importPair = !ApplicationManager.getApplication().isUnitTestMode() ? ImportSchemeChooserDialog.selectOrCreateTargetScheme(project, currentScheme, schemeFactory, CodeStyleSchemeXmlImporter.getSchemeName(schemeRoot)) : Pair.create((Object)currentScheme.getName(), (Object)currentScheme);
        if (importPair != null) {
            return CodeStyleSchemeXmlImporter.readSchemeFromDom(schemeRoot, (CodeStyleScheme)importPair.second);
        }
        return null;
    }

    @NotNull
    private static String getSchemeName(@NotNull Element rootElement) throws SchemeImportException {
        String rootName = rootElement.getName();
        if ("value".equals(rootElement.getName())) {
            return "Project";
        }
        if (!"code_scheme".equals(rootName)) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.invalid.file", (Object[])new Object[]{rootName}));
        }
        Attribute schemeNameAttr = rootElement.getAttribute("name");
        if (schemeNameAttr == null) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.missing.scheme.name", (Object[])new Object[0]));
        }
        return schemeNameAttr.getValue();
    }

    private static CodeStyleScheme readSchemeFromDom(@NotNull Element rootElement, @NotNull CodeStyleScheme scheme) throws SchemeImportException {
        CodeStyleSettings newSettings = CodeStyleSettingsManager.getInstance().createSettings();
        CodeStyleSchemeXmlImporter.loadSettings(rootElement, newSettings);
        newSettings.resetDeprecatedFields();
        ((CodeStyleSchemeImpl)scheme).setCodeStyleSettings(newSettings);
        return scheme;
    }
}

