/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleFacadeImpl
extends CodeStyleFacade {
    @Nullable
    private final Project myProject;

    public CodeStyleFacadeImpl() {
        this(null);
    }

    public CodeStyleFacadeImpl(@Nullable Project project) {
        this.myProject = project;
    }

    @Deprecated
    public int getIndentSize(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings((Project)this.myProject).getIndentSize(fileType);
    }

    @Deprecated
    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        if (this.myProject == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        return CodeStyleManager.getInstance((Project)this.myProject).getLineIndent(document, offset);
    }

    public String getLineIndent(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        String indent;
        if (this.myProject == null) {
            return null;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        String string = indent = lineIndentProvider != null ? lineIndentProvider.getLineIndent(this.myProject, editor, language, offset) : null;
        if (indent == LineIndentProvider.DO_NOT_ADJUST) {
            return allowDocCommit ? null : indent;
        }
        return indent != null ? indent : (allowDocCommit ? this.getLineIndent(editor.getDocument(), offset) : null);
    }

    public int getJoinedLinesSpacing(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        int space;
        if (this.myProject == null) {
            return 0;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        int n = space = lineIndentProvider instanceof JoinedLinesSpacingCalculator ? ((JoinedLinesSpacingCalculator)lineIndentProvider).getJoinedLinesSpacing(this.myProject, editor, language, offset) : -1;
        if (space < 0 && allowDocCommit) {
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (file2 == null) {
                return 0;
            }
            return Math.max(0, CodeStyleManager.getInstance((Project)this.myProject).getSpacing(file2, offset));
        }
        return Math.max(0, space);
    }

    public String getLineSeparator() {
        return CodeStyle.getProjectOrDefaultSettings((Project)this.myProject).getLineSeparator();
    }

    public int getTabSize(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings((Project)this.myProject).getTabSize(fileType);
    }

    public boolean useTabCharacter(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings((Project)this.myProject).useTabCharacter(fileType);
    }

    public boolean useSpaceBeforeComma(@NotNull PsiFile psiFile, @NotNull Language language) {
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language).SPACE_BEFORE_COMMA;
    }

    public boolean useSpaceAfterComma(@NotNull PsiFile psiFile, @NotNull Language language) {
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language).SPACE_AFTER_COMMA;
    }

    public boolean useSpaceAroundAssignmentOperators(@NotNull PsiFile psiFile, @NotNull Language language) {
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language).SPACE_AROUND_ASSIGNMENT_OPERATORS;
    }
}

