/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance(LowLevelSearchUtil.class);
    private static final ConcurrentMap<CharSequence, Map<StringSearcher, int[]>> cache = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());

    private static Boolean processInjectedFile(PsiElement element2, @NotNull StringSearcher searcher, int start2, @NotNull ProgressIndicator progress2, InjectedLanguageManager injectedLanguageManager, @NotNull TextOccurenceProcessor processor2) {
        if (!(element2 instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List list2 = injectedLanguageManager.getInjectedPsiFiles(element2);
        if (list2 == null) {
            return null;
        }
        boolean hasMatchedRange = false;
        for (Pair pair : list2) {
            if (!((TextRange)pair.second).containsRange(start2, start2 + searcher.getPatternLength())) continue;
            hasMatchedRange = true;
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor2, injected, searcher, false, progress2)) continue;
            return Boolean.FALSE;
        }
        return hasMatchedRange ? Boolean.TRUE : null;
    }

    private static boolean processTreeUp(@NotNull Project project, @NotNull PsiElement scope, @NotNull ASTNode leafNode, int offsetInLeaf, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2, @NotNull TextOccurenceProcessor processor2) {
        int patternLength = searcher.getPatternLength();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        ASTNode currentNode = leafNode;
        int currentOffset = offsetInLeaf;
        boolean contains = false;
        ASTNode prevNode = null;
        PsiElement run2 = null;
        while (run2 != scope) {
            ProgressManager.checkCanceled();
            currentOffset += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
            prevNode = currentNode;
            run2 = currentNode.getPsi();
            if (!contains) {
                boolean bl = contains = run2.getTextLength() - currentOffset >= patternLength;
            }
            if (contains) {
                Boolean result2;
                if (processInjectedPsi && (result2 = LowLevelSearchUtil.processInjectedFile(run2, searcher, currentOffset, progress2, injectedLanguageManager, processor2)) != null) {
                    return result2;
                }
                if (!processor2.execute(run2, currentOffset)) {
                    return false;
                }
            }
            if ((currentNode = currentNode.getTreeParent()) != null) continue;
        }
        assert (run2 == scope) : "Malbuilt PSI; scopeNode: " + scope + "; containingFile: " + PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false) + "; currentNode: " + run2 + "; isAncestor: " + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run2, (boolean)false) + "; in same file: " + (PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false) == PsiTreeUtil.getParentOfType((PsiElement)run2, PsiFile.class, (boolean)false));
        return true;
    }

    private static ASTNode findNextLeafElementAt(ASTNode scopeNode, ASTNode last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                ASTNode next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor2, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2) {
        int[] occurrences = LowLevelSearchUtil.getTextOccurrencesInScope(scope, searcher);
        return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, processInjectedPsi, progress2, occurrences, processor2);
    }

    static int @NotNull [] getTextOccurrencesInScope(@NotNull PsiElement scope, @NotNull StringSearcher searcher) {
        ProgressManager.checkCanceled();
        PsiFile file2 = scope.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range2 = scope.getTextRange();
        if (range2 == null) {
            LOG.error("Element " + scope + " of class " + scope.getClass() + " has null range");
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file2, viewProvider, buffer, range2);
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] offsets2 = LowLevelSearchUtil.getTextOccurrences(buffer, startOffset, endOffset, searcher);
        int i2 = 0;
        while (i2 < offsets2.length) {
            int n = i2++;
            offsets2[n] = offsets2[n] - startOffset;
        }
        return offsets2;
    }

    static boolean processElementsAtOffsets(@NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2, int @NotNull [] offsetsInScope, @NotNull TextOccurenceProcessor processor2) {
        if (offsetsInScope.length == 0) {
            return true;
        }
        ASTNode scopeNode = scope.getNode();
        if (scopeNode == null) {
            throw new IllegalArgumentException("Scope doesn't have node, can't scan: " + scope + "; containingFile: " + scope.getContainingFile());
        }
        Project project = scope.getProject();
        return LowLevelSearchUtil.processOffsets(scopeNode, offsetsInScope, progress2, (node, offsetInNode) -> LowLevelSearchUtil.processTreeUp(project, scope, node, offsetInNode, searcher, processInjectedPsi, progress2, processor2));
    }

    static boolean processOffsets(@NotNull ASTNode node, int @NotNull [] offsetsInNode, @NotNull ProgressIndicator progress2, @NotNull NodeTextOccurrenceProcessor processor2) {
        int scopeStartOffset = node.getStartOffset();
        ASTNode lastElement = null;
        for (int offset : offsetsInNode) {
            progress2.checkCanceled();
            ASTNode leafNode = LowLevelSearchUtil.findNextLeafElementAt(node, lastElement, offset);
            if (leafNode == null) {
                LOG.error("Cannot find leaf: node=" + node + "; offset=" + offset + "; lastElement=" + lastElement);
                continue;
            }
            int offsetInLeaf = offset - leafNode.getStartOffset() + scopeStartOffset;
            if (offsetInLeaf < 0) {
                throw new AssertionError((Object)("offset=" + offset + "; scopeStartOffset=" + scopeStartOffset + "; node=" + node));
            }
            if (!processor2.execute(leafNode, offsetInLeaf)) {
                return false;
            }
            lastElement = leafNode;
        }
        return true;
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, PsiFile file2, FileViewProvider viewProvider, CharSequence buffer, TextRange range2) {
        String msg = "Range for element: '" + scope + "' = " + range2 + " is out of file '" + file2 + "' range: " + file2.getTextRange();
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + viewProvider;
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance((Project)file2.getProject()).isCommitted(document);
        }
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            msg = msg + "\n root " + language + " length=" + root.getTextLength() + (root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static boolean processTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress2, @NotNull TIntProcedure processor2) {
        return LowLevelSearchUtil.processTextOccurrences(text, startOffset, endOffset, searcher, processor2);
    }

    public static boolean processTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @NotNull TIntProcedure processor2) {
        for (int offset : LowLevelSearchUtil.getTextOccurrences(text, startOffset, endOffset, searcher)) {
            if (processor2.execute(offset)) continue;
            return false;
        }
        return true;
    }

    private static int @NotNull [] getTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher) {
        int occurrence;
        boolean hasCachedOccurrences;
        if (endOffset > text.length()) {
            throw new IllegalArgumentException("end: " + endOffset + " > length: " + text.length());
        }
        Map cachedMap = (Map)cache.get(text);
        int[] cachedOccurrences = cachedMap == null ? null : (int[])cachedMap.get(searcher);
        boolean bl = hasCachedOccurrences = cachedOccurrences != null && cachedOccurrences[0] <= startOffset && cachedOccurrences[1] >= endOffset;
        if (!hasCachedOccurrences) {
            TIntArrayList occurrences = new TIntArrayList();
            int newStart = Math.min(startOffset, cachedOccurrences == null ? startOffset : cachedOccurrences[0]);
            int newEnd = Math.max(endOffset, cachedOccurrences == null ? endOffset : cachedOccurrences[1]);
            occurrences.add(newStart);
            occurrences.add(newEnd);
            for (int index = newStart; index < newEnd; ++index) {
                ProgressManager.checkCanceled();
                index = searcher.scan(text, index, newEnd);
                if (index < 0) break;
                if (!LowLevelSearchUtil.checkJavaIdentifier(text, searcher, index)) continue;
                occurrences.add(index);
            }
            cachedOccurrences = occurrences.toNativeArray();
            if (cachedMap == null) {
                cachedMap = (Map)ConcurrencyUtil.cacheOrGet(cache, (Object)text, (Object)ContainerUtil.createConcurrentSoftMap());
            }
            cachedMap.put(searcher, cachedOccurrences);
        }
        TIntArrayList offsets2 = new TIntArrayList(cachedOccurrences.length - 2);
        for (int i2 = 2; i2 < cachedOccurrences.length && (occurrence = cachedOccurrences[i2]) <= endOffset - searcher.getPatternLength(); ++i2) {
            if (occurrence < startOffset) continue;
            offsets2.add(occurrence);
        }
        return offsets2.toNativeArray();
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text, @NotNull StringSearcher searcher, int index) {
        char c;
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index > 0 && (Character.isJavaIdentifierPart(c = text.charAt(index - 1)) && c != '$' ? !searcher.isHandleEscapeSequences() || index < 2 || StringUtil.isEscapedBackslash((CharSequence)text, (int)0, (int)(index - 2)) : searcher.isHandleEscapeSequences() && !StringUtil.isEscapedBackslash((CharSequence)text, (int)0, (int)(index - 1)))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        if (index + patternLength < text.length()) {
            char c2 = text.charAt(index + patternLength);
            return !Character.isJavaIdentifierPart(c2) || c2 == '$';
        }
        return true;
    }

    static interface NodeTextOccurrenceProcessor {
        public boolean execute(@NotNull ASTNode var1, int var2);
    }
}

