/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpdateAddedFileProcessor {
    private static final ExtensionPointName<UpdateAddedFileProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.updateAddedFileProcessor");

    public abstract boolean canProcessElement(@NotNull PsiFile var1);

    public abstract void update(PsiFile var1, @Nullable PsiFile var2) throws IncorrectOperationException;

    @Nullable
    public static UpdateAddedFileProcessor forElement(@NotNull PsiFile element2) {
        for (UpdateAddedFileProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!processor2.canProcessElement(element2)) continue;
            return processor2;
        }
        return null;
    }

    public static void updateAddedFiles(@NotNull Iterable<? extends PsiFile> copyPsis) throws IncorrectOperationException {
        for (PsiFile psiFile : copyPsis) {
            UpdateAddedFileProcessor processor2 = UpdateAddedFileProcessor.forElement(psiFile);
            if (processor2 == null) continue;
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)psiFile);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor2.update(psiFile, null);
            if (tree == null) continue;
            ChangeUtil.decodeInformation(tree);
        }
    }
}

