/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformIdTableBuilding {
    public static final Key<EditorHighlighter> EDITOR_HIGHLIGHTER = new Key("Editor");
    private static final TokenSet ABSTRACT_FILE_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    private PlatformIdTableBuilding() {
    }

    @Nullable
    public static DataIndexer<TodoIndexEntry, Integer, FileContent> getTodoIndexer(FileType fileType) {
        DataIndexer extIndexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        if (fileType instanceof LanguageFileType) {
            TokenSet commentTokens;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet tokenSet = commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            if (commentTokens != null) {
                return new TokenSetTodoIndexer(commentTokens);
            }
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new TokenSetTodoIndexer(ABSTRACT_FILE_COMMENT_TOKENS);
        }
        return null;
    }

    public static boolean checkCanUseCachedEditorHighlighter(CharSequence chars, EditorHighlighter editorHighlighter) {
        assert (editorHighlighter instanceof LexerEditorHighlighter);
        boolean b = ((LexerEditorHighlighter)editorHighlighter).checkContentIsEqualTo(chars);
        if (!b) {
            Logger logger = Logger.getInstance((String)IdTableBuilding.class.getName());
            logger.warn("Unexpected mismatch of editor highlighter content with indexing content");
        }
        return b;
    }

    public static boolean isTodoIndexerRegistered(@NotNull FileType fileType) {
        return TodoIndexers.INSTANCE.forFileType(fileType) != null || fileType instanceof InternalFileType;
    }

    private static class TokenSetTodoIndexer
    extends VersionedTodoIndexer {
        @NotNull
        private final TokenSet myCommentTokens;

        TokenSetTodoIndexer(@NotNull TokenSet commentTokens) {
            this.myCommentTokens = commentTokens;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (IndexPatternUtil.getIndexPatternCount() > 0) {
                EditorHighlighter highlighter;
                CharSequence chars = inputData.getContentAsText();
                OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
                EditorHighlighter editorHighlighter = (EditorHighlighter)inputData.getUserData(EDITOR_HIGHLIGHTER);
                if (editorHighlighter != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(chars, editorHighlighter)) {
                    highlighter = editorHighlighter;
                } else {
                    highlighter = HighlighterFactory.createHighlighter((Project)inputData.getProject(), (VirtualFile)inputData.getFile());
                    highlighter.setText(chars);
                }
                int documentLength = chars.length();
                BaseFilterLexer.TodoScanningState todoScanningState = null;
                HighlighterIterator iterator2 = highlighter.createIterator(0);
                while (!iterator2.atEnd()) {
                    IElementType token = iterator2.getTokenType();
                    if (this.myCommentTokens.contains(token) || CacheUtil.isInComments(token)) {
                        int start2 = iterator2.getStart();
                        if (start2 >= documentLength) break;
                        int end = iterator2.getEnd();
                        todoScanningState = BaseFilterLexer.advanceTodoItemsCount(chars.subSequence(start2, Math.min(end, documentLength)), occurrenceConsumer, todoScanningState);
                        if (end > documentLength) break;
                    }
                    iterator2.advance();
                }
                HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
                for (IndexPattern pattern : IndexPatternUtil.getIndexPatterns()) {
                    int count = occurrenceConsumer.getOccurrenceCount(pattern);
                    if (count <= 0) continue;
                    map2.put(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), count);
                }
                return map2;
            }
            return Collections.emptyMap();
        }

        @Override
        public int getVersion() {
            return 2;
        }
    }
}

