/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.util.indexing.FileContent;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextIdIndexer
implements IdIndexer {
    private static final Key<Map<IdIndexEntry, Integer>> ID_INDEX_DATA_KEY = Key.create((String)"plain.text.id.index");

    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        return PlainTextIdIndexer.getIdIndexData(inputData);
    }

    @NotNull
    public static Map<IdIndexEntry, Integer> getIdIndexData(@NotNull FileContent content2) {
        Map idIndexData = (Map)content2.getUserData(ID_INDEX_DATA_KEY);
        if (idIndexData != null) {
            content2.putUserData(ID_INDEX_DATA_KEY, null);
            return idIndexData;
        }
        final IdDataConsumer consumer = new IdDataConsumer();
        CharSequence text = content2.getContentAsText();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars11, char @Nullable [] charsArray, int start2, int end) {
                if (charsArray != null) {
                    consumer.addOccurrence(charsArray, start2, end, 16);
                } else {
                    consumer.addOccurrence(chars11, start2, end, 16);
                }
            }
        }, text, 0, text.length());
        Map<IdIndexEntry, Integer> result2 = consumer.getResult();
        if (TodoIndexers.needsTodoIndex(content2.getFile()) && IdIndex.isIndexable((FileType)PlainTextFileType.INSTANCE)) {
            content2.putUserData(ID_INDEX_DATA_KEY, result2);
        }
        return result2;
    }
}

