/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PsiParserFacadeImpl
implements PsiParserFacade {
    private final PsiManagerEx myManager;

    public PsiParserFacadeImpl(@NotNull Project project) {
        this.myManager = PsiManagerEx.getInstanceEx(project);
    }

    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern((CharSequence)text));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        return newElement.getPsi();
    }

    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text) throws IncorrectOperationException {
        return this.createLineCommentFromText(fileType.getLanguage(), text);
    }

    @NotNull
    public PsiComment createLineCommentFromText(@NotNull Language language, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + language.getID());
        }
        PsiFile aFile = this.createDummyFile(language, prefix + text);
        return this.findPsiCommentChild(aFile);
    }

    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = this.createDummyFile(language, blockCommentPrefix + text + blockCommentSuffix);
        return this.findPsiCommentChild(aFile);
    }

    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language language, @NotNull String text) throws IncorrectOperationException {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        assert (commenter != null) : language;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = this.createDummyFile(language, prefix != null ? prefix + text : blockCommentPrefix + text + blockCommentSuffix);
        return this.findPsiCommentChild(aFile);
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiComment comment = (PsiComment)PsiTreeUtil.findChildOfType((PsiElement)aFile, PsiComment.class);
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
        }
        DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)comment), null);
        return comment;
    }

    private PsiFile createDummyFile(Language language, String text) {
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("_Dummy_", language, (CharSequence)text);
    }
}

