/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement,
Cloneable {
    private static final Logger LOG = Logger.getInstance(PsiElementBase.class);

    public PsiElement getFirstChild() {
        PsiElement[] children2 = this.getChildren();
        if (children2.length == 0) {
            return null;
        }
        return children2[0];
    }

    public PsiElement getLastChild() {
        PsiElement[] children2 = this.getChildren();
        if (children2.length == 0) {
            return null;
        }
        return children2[children2.length - 1];
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        for (PsiElement child2 = this.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            child2.accept(visitor);
        }
    }

    public PsiReference getReference() {
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        return SharedPsiElementImplUtil.getReferences((PsiElement)this);
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this, offset);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return ResolveScopeManager.getElementResolveScope((PsiElement)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return ResolveScopeManager.getElementUseScope((PsiElement)this);
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return manager.getProject();
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return parent.getContainingFile();
    }

    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    public boolean isValid() {
        PsiElement parent;
        for (parent = this.getParent(); parent != null && parent.getClass() == this.getClass(); parent = parent.getParent()) {
        }
        return parent != null && parent.isValid();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        return Comparing.equal((CharSequence)this.getText(), (CharSequence)text, (boolean)true);
    }

    public boolean textMatches(@NotNull PsiElement element2) {
        return this.getText().equals(element2.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitElement((PsiElement)this);
    }

    public String getName() {
        return null;
    }

    @NotNull
    protected <T> T notNullChild(T child2) {
        if (child2 == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        return child2;
    }

    protected <T> T @NotNull [] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            result2.add(cur);
        }
        return result2.toArray(ArrayUtil.newArray(aClass, (int)result2.size()));
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        return this.notNullChild(this.findChildByClass(aClass));
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }
}

