/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarPanel;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidgetFactory;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidget
extends EditorBasedStatusBarPopup
implements CodeStyleSettingsListener {
    public static final String WIDGET_ID = CodeStyleStatusBarWidget.class.getName();
    private CodeStyleStatusBarPanel myPanel;

    public CodeStyleStatusBarWidget(@NotNull Project project) {
        super(project, true);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiFile);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)psiFile);
        if (settings instanceof TransientCodeStyleSettings) {
            return CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, CodeStyleStatusBarWidget.getUiContributor((TransientCodeStyleSettings)settings));
        }
        return CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, (CodeStyleStatusBarUIContributor)CodeStyleStatusBarWidget.getUiContributor(file2, indentOptions));
    }

    @Nullable
    private static CodeStyleStatusBarUIContributor getUiContributor(@NotNull TransientCodeStyleSettings settings) {
        CodeStyleSettingsModifier modifier = settings.getModifier();
        return modifier != null ? modifier.getStatusBarUiContributor(settings) : null;
    }

    @Nullable
    private static IndentStatusBarUIContributor getUiContributor(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider provider = CodeStyleStatusBarWidget.findProvider(file2, indentOptions);
        if (provider != null) {
            return provider.getIndentStatusBarUiContributor(indentOptions);
        }
        return null;
    }

    @Nullable
    private static FileIndentOptionsProvider findProvider(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider optionsProvider = indentOptions.getFileIndentOptionsProvider();
        if (optionsProvider != null) {
            return optionsProvider;
        }
        for (FileIndentOptionsProvider provider : (FileIndentOptionsProvider[])FileIndentOptionsProvider.EP_NAME.getExtensions()) {
            IndentStatusBarUIContributor uiContributor = provider.getIndentStatusBarUiContributor(indentOptions);
            if (uiContributor == null || !uiContributor.areActionsAvailable(file2)) continue;
            return provider;
        }
        return null;
    }

    private static EditorBasedStatusBarPopup.WidgetState createWidgetState(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
        if (uiContributor != null) {
            return new MyWidgetState(uiContributor.getTooltip(), uiContributor.getStatusText(psiFile), psiFile, indentOptions, uiContributor);
        }
        String indentInfo = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)indentOptions);
        String tooltip = IndentStatusBarUIContributor.createTooltip((String)indentInfo, null);
        return new MyWidgetState(tooltip, indentInfo, psiFile, indentOptions, null);
    }

    @Nullable
    private PsiFile getPsiFile() {
        Editor editor = this.getEditor();
        Project project = this.getProject();
        if (editor != null && !project.isDisposed()) {
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return null;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState((VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE));
        Editor editor = this.getEditor();
        PsiFile psiFile = this.getPsiFile();
        if (state instanceof MyWidgetState && editor != null && psiFile != null) {
            CodeStyleStatusBarUIContributor uiContributor = ((MyWidgetState)state).getContributor();
            final AnAction[] actions = CodeStyleStatusBarWidget.getActions(uiContributor, psiFile);
            ActionGroup actionGroup = new ActionGroup(){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    return actions;
                }
            };
            return JBPopupFactory.getInstance().createActionGroupPopup(uiContributor != null ? uiContributor.getActionGroupTitle() : null, actionGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }
        return null;
    }

    private static AnAction @NotNull [] getActions(@Nullable CodeStyleStatusBarUIContributor uiContributor, @NotNull PsiFile psiFile) {
        AnAction[] actions;
        ArrayList<Object> allActions = new ArrayList<Object>();
        if (uiContributor != null && (actions = uiContributor.getActions(psiFile)) != null) {
            allActions.addAll(Arrays.asList(actions));
        }
        if (uiContributor == null || uiContributor instanceof IndentStatusBarUIContributor && ((IndentStatusBarUIContributor)uiContributor).isShowFileIndentOptionsEnabled()) {
            allActions.add(CodeStyleStatusBarWidgetFactory.createDefaultIndentConfigureAction(psiFile));
        }
        if (uiContributor != null) {
            AnAction showAllAction;
            AnAction disabledAction = uiContributor.createDisableAction(psiFile.getProject());
            if (disabledAction != null) {
                allActions.add(disabledAction);
            }
            if ((showAllAction = uiContributor.createShowAllAction(psiFile.getProject())) != null) {
                allActions.add(showAllAction);
            }
        }
        return allActions.toArray(AnAction.EMPTY_ARRAY);
    }

    @Override
    protected void registerCustomListeners() {
        Project project = this.getProject();
        ReadAction.nonBlocking(() -> CodeStyleSettingsManager.getInstance((Project)project)).expireWith((Disposable)project).finishOnUiThread(ModalityState.any(), manager -> {
            manager.addListener((CodeStyleSettingsListener)this);
            Disposer.register((Disposable)this, () -> CodeStyleSettingsManager.removeListener((Project)project, (CodeStyleSettingsListener)this));
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        this.update();
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new CodeStyleStatusBarWidget(project);
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    @Override
    protected JPanel createComponent() {
        this.myPanel = new CodeStyleStatusBarPanel();
        return this.myPanel;
    }

    @Override
    protected void updateComponent(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        this.myPanel.setIcon(state.getIcon());
        this.myPanel.setText(state.getText());
        this.myPanel.setToolTipText(state.getToolTip());
    }

    @Override
    protected boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myPanel.getText());
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        @NotNull
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
        @Nullable
        private final CodeStyleStatusBarUIContributor myContributor;
        @NotNull
        private final PsiFile myPsiFile;

        protected MyWidgetState(String toolTip, String text, @NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
            super(toolTip, text, true);
            this.myIndentOptions = indentOptions;
            this.myContributor = uiContributor;
            this.myPsiFile = psiFile;
            if (uiContributor != null) {
                this.setIcon(uiContributor.getIcon());
            }
        }

        @Nullable
        public CodeStyleStatusBarUIContributor getContributor() {
            return this.myContributor;
        }

        @NotNull
        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            return this.myIndentOptions;
        }

        @NotNull
        public PsiFile getPsiFile() {
            return this.myPsiFile;
        }
    }
}

