/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends AbstractFileViewProvider {
    protected final ConcurrentMap<Language, PsiFileImpl> myRoots = ContainerUtil.newConcurrentMap((int)1, (float)0.75f, (int)1);
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal;

    public MultiplePsiFilesPerDocumentFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        super(manager, virtualFile, eventSystemEnabled);
    }

    @NotNull
    public abstract Language getBaseLanguage();

    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        return roots;
    }

    protected final void removeFile(@NotNull Language language) {
        PsiFileImpl file2 = (PsiFileImpl)this.myRoots.remove(language);
        if (file2 != null) {
            file2.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target2) {
        PsiFileImpl file2 = (PsiFileImpl)this.myRoots.get(target2);
        if (file2 == null) {
            PsiFile originalFile;
            if (!this.shouldCreatePsi()) {
                return null;
            }
            if (target2 != this.getBaseLanguage() && !this.getLanguages().contains(target2)) {
                return null;
            }
            file2 = this.createPsiFileImpl(target2);
            if (file2 == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target2)) != null) {
                file2.setOriginalFile(originalFile);
            }
            file2 = (PsiFileImpl)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)target2, (Object)file2);
        }
        return file2;
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language target2) {
        return (PsiFileImpl)this.createFile(target2);
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target2) {
        return (PsiFile)this.myRoots.get(target2);
    }

    @Override
    @NotNull
    public final List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.mapNotNull(this.myRoots.keySet(), this::getCachedPsi);
    }

    @Override
    @NotNull
    public final List<FileElement> getKnownTreeRoots() {
        ArrayList<FileElement> files2 = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file2 : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file2).getTreeElement();
            if (treeElement == null) continue;
            files2.add(treeElement);
        }
        return files2;
    }

    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            assert (document != null);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        MultiplePsiFilesPerDocumentFileViewProvider copy2 = this.cloneInner(fileCopy);
        copy2.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        return copy2;
    }

    @NotNull
    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile var1);

    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt((PsiElement)(psiRoot = this.getPsi(language)), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference2 = SharedPsiElementImplUtil.findReferenceAt((PsiElement)psiRoot, offset, language);
            if (reference2 == null || !minRange.contains(textRange = reference2.getRangeInElement().shiftRight(reference2.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange) && ret != null) continue;
            minRange = textRange;
            ret = reference2;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set languages = this.getLanguages();
        Iterator iterator2 = this.myRoots.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file2 = (PsiFileImpl)entry.getValue();
            iterator2.remove();
            DebugUtil.performPsiModification(((Object)((Object)this)).getClass().getName() + " root change", () -> file2.markInvalidated());
        }
        super.contentsSynchronized();
    }
}

