/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsRootModel
extends RootModelBase
implements ModuleRootModel {
    private final Module myModule;
    private final List<ContentEntry> myContentEntries;

    public JpsRootModel(Module module, JpsModule jpsModule) {
        this.myModule = module;
        this.myContentEntries = new ArrayList<ContentEntry>();
        for (String contentRoot : jpsModule.getContentRootsList().getUrls()) {
            this.myContentEntries.add(new JpsContentEntry(jpsModule, this, contentRoot));
        }
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Override
    protected Collection<ContentEntry> getContent() {
        return this.myContentEntries;
    }

    public OrderEntry @NotNull [] getOrderEntries() {
        return OrderEntry.EMPTY_ARRAY;
    }

    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        throw new UnsupportedOperationException("'getModuleExtension' not implemented in " + this.getClass().getName());
    }

    public Project getProject() {
        return this.myModule.getProject();
    }
}

