/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsagesPanel
extends JPanel
implements Disposable,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(UsagesPanel.class);
    private final Project myProject;
    ProgressIndicator myCurrentProgress;
    private JComponent myCurrentComponent;
    private UsageView myCurrentUsageView;
    protected final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public UsagesPanel(@NotNull Project project) {
        super(new BorderLayout());
        this.myProject = project;
    }

    public void setToInitialPosition() {
        this.cancelCurrentFindRequest();
        this.setToComponent(UsagesPanel.createLabel(this.getInitialPositionText()));
    }

    @Nls
    public abstract String getInitialPositionText();

    @Nls
    public abstract String getCodeUsagesString();

    void cancelCurrentFindRequest() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    protected void showUsages(PsiElement @NotNull [] primaryElements, UsageInfo @NotNull [] usageInfos) {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
        }
        try {
            Usage[] usages = UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo[])usageInfos);
            UsageViewPresentation presentation2 = new UsageViewPresentation();
            presentation2.setCodeUsagesString(this.getCodeUsagesString());
            this.myCurrentUsageView = UsageViewManager.getInstance((Project)this.myProject).createUsageView(UsageTarget.EMPTY_ARRAY, usages, presentation2, null);
            this.setToComponent(this.myCurrentUsageView.getComponent());
        }
        catch (ProcessCanceledException e) {
            this.setToCanceled();
        }
    }

    private void setToCanceled() {
        this.setToComponent(UsagesPanel.createLabel(CodeInsightBundle.message((String)"usage.view.canceled", (Object[])new Object[0])));
    }

    final void setToComponent(@NotNull JComponent component2) {
        ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)ModalityState.any()).expireWith((Disposable)this.myProject)).execute(() -> {
            if (this.myCurrentComponent != null) {
                if (this.myCurrentUsageView != null && this.myCurrentComponent == this.myCurrentUsageView.getComponent()) {
                    Disposer.dispose((Disposable)this.myCurrentUsageView);
                    this.myCurrentUsageView = null;
                }
                this.remove(this.myCurrentComponent);
            }
            this.myCurrentComponent = component2;
            this.add((Component)component2, "Center");
            this.revalidate();
        });
    }

    public void dispose() {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
            this.myCurrentUsageView = null;
        }
    }

    private static JComponent createLabel(String text) {
        JLabel label2 = new JLabel(text);
        label2.setHorizontalAlignment(0);
        return label2;
    }

    @Nullable
    @NonNls
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "ideaInterface.find";
        }
        return null;
    }
}

