/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetHandler;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesOnSpecifiedTargetAction
extends AnAction {
    public static final DataKey<GlobalSearchScope> TARGET_SCOPE_KEY = DataKey.create((String)"MODULE_DEPENDENCIES_TARGET_SCOPE");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        GlobalSearchScope targetScope = (GlobalSearchScope)e.getData(TARGET_SCOPE_KEY);
        if (module == null || targetScope == null) {
            return;
        }
        new AnalyzeDependenciesOnSpecifiedTargetHandler(module.getProject(), new AnalysisScope(module), targetScope).analyze();
    }

    public void update(@NotNull AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        GlobalSearchScope scope = (GlobalSearchScope)e.getData(TARGET_SCOPE_KEY);
        Presentation presentation2 = e.getPresentation();
        if (module != null && scope != null) {
            presentation2.setVisible(true);
            presentation2.setText(CodeInsightBundle.message((String)"analyze.dependencies.on.scope.action.text", (Object[])new Object[]{module.getName(), scope.getDisplayName()}));
        } else {
            presentation2.setVisible(false);
        }
    }
}

