/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyVisitorFactory {
    private static final LanguageExtension<DependencyVisitorFactory> EP_NAME = new LanguageExtension("com.intellij.packageDependencies.visitor");

    @NotNull
    public abstract PsiElementVisitor getVisitor(@NotNull DependenciesBuilder.DependencyProcessor var1, @NotNull VisitorOptions var2);

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull PsiFile file2, @NotNull DependenciesBuilder.DependencyProcessor processor2, @NotNull VisitorOptions options2) {
        DependencyVisitorFactory factory2 = (DependencyVisitorFactory)EP_NAME.forLanguage(file2.getLanguage());
        return factory2 != null ? factory2.getVisitor(processor2, options2) : new DefaultVisitor(processor2);
    }

    private static class DefaultVisitor
    extends PsiRecursiveElementVisitor {
        private final DependenciesBuilder.DependencyProcessor myProcessor;

        DefaultVisitor(@NotNull DependenciesBuilder.DependencyProcessor processor2) {
            this.myProcessor = processor2;
        }

        public void visitElement(@NotNull PsiElement element2) {
            super.visitElement(element2);
            for (PsiReference ref : element2.getReferences()) {
                PsiElement resolved = ref.resolve();
                if (resolved == null) continue;
                this.myProcessor.process(ref.getElement(), resolved);
            }
        }
    }

    public static abstract class VisitorOptions {
        public static final VisitorOptions SKIP_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return true;
            }
        };
        public static final VisitorOptions INCLUDE_IMPORTS = new VisitorOptions(){

            @Override
            public boolean skipImports() {
                return false;
            }
        };

        public abstract boolean skipImports();

        public static VisitorOptions fromSettings(@NotNull Project project) {
            final DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
            return new VisitorOptions(){

                @Override
                public boolean skipImports() {
                    return manager.skipImportStatements();
                }
            };
        }
    }
}

