/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeScreenFocusManager {
    static void installFocusable(final @NotNull Container parentContainer, final JComponent comp, final AnAction action2, final int nextKeyCode, final int prevKeyCode, final @Nullable Component focusedOnLeft) {
        comp.setFocusable(true);
        comp.setFocusTraversalKeysEnabled(true);
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    ActionLink link;
                    InputEvent event = e;
                    if (e.getComponent() instanceof JComponent && (link = (ActionLink)UIUtil.findComponentOfType((JComponent)((JComponent)e.getComponent()), ActionLink.class)) != null) {
                        event = new MouseEvent((Component)link, 500, e.getWhen(), e.getModifiers(), 0, 0, 1, false, 1);
                    }
                    action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)event, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext()));
                } else if (e.getKeyCode() == prevKeyCode) {
                    WelcomeScreenFocusManager.focusPrev(parentContainer, comp);
                } else if (e.getKeyCode() == nextKeyCode) {
                    WelcomeScreenFocusManager.focusNext(parentContainer, comp);
                } else if (e.getKeyCode() == 37) {
                    if (focusedOnLeft != null) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(focusedOnLeft, true));
                    } else {
                        WelcomeScreenFocusManager.focusPrev(parentContainer, comp);
                    }
                } else if (e.getKeyCode() == 39) {
                    WelcomeScreenFocusManager.focusNext(parentContainer, comp);
                }
            }
        });
        comp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                comp.setOpaque(true);
                comp.setBackground(WelcomeScreenUIManager.getActionLinkSelectionColor());
            }

            @Override
            public void focusLost(FocusEvent e) {
                comp.setOpaque(false);
                comp.setBackground(WelcomeScreenUIManager.getMainBackground());
            }
        });
    }

    private static void focusPrev(@NotNull Container container2, JComponent comp) {
        Component prev;
        FocusTraversalPolicy policy = container2.getFocusTraversalPolicy();
        if (policy != null && (prev = policy.getComponentBefore(container2, comp)) != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(prev, true));
        }
    }

    private static void focusNext(@NotNull Container container2, JComponent comp) {
        Component next;
        FocusTraversalPolicy policy = container2.getFocusTraversalPolicy();
        if (policy != null && (next = policy.getComponentAfter(container2, comp)) != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
        }
    }
}

