/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeScreenComponentFactory {
    @NotNull
    static JComponent createSmallLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        String welcomeScreenLogoUrl = appInfo.getApplicationSvgIconUrl();
        if (welcomeScreenLogoUrl != null) {
            Icon icon2 = IconLoader.getIcon((String)welcomeScreenLogoUrl);
            float scale = 28.0f / (float)icon2.getIconWidth();
            Icon smallLogoIcon = IconUtil.scale((Icon)icon2, null, (float)scale);
            JLabel logo = new JLabel(smallLogoIcon);
            logo.setBorder((Border)JBUI.Borders.empty((int)29, (int)0, (int)27, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"West");
        }
        String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
        JLabel appName = new JLabel(applicationName);
        appName.setForeground(JBColor.foreground());
        appName.setFont(appName.getFont().deriveFont(0));
        appName.setHorizontalAlignment(0);
        String appVersion = appInfo.getFullVersion();
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version2 = new JLabel(appVersion);
        version2.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        version2.setHorizontalAlignment(0);
        version2.setForeground((Color)Gray._128);
        NonOpaquePanel textPanel = new NonOpaquePanel();
        textPanel.setLayout((LayoutManager)new BoxLayout((Container)textPanel, 1));
        textPanel.setBorder((Border)JBUI.Borders.empty((int)28, (int)10, (int)25, (int)10));
        textPanel.add((Component)appName);
        textPanel.add((Component)version2);
        panel2.add((Component)textPanel, (Object)"Center");
        return panel2;
    }

    @NotNull
    static JComponent createLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        String welcomeScreenLogoUrl = appInfo.getWelcomeScreenLogoUrl();
        if (welcomeScreenLogoUrl != null) {
            JLabel logo = new JLabel(IconLoader.getIcon((String)welcomeScreenLogoUrl));
            logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"North");
        }
        String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
        JLabel appName = new JLabel(applicationName);
        appName.setForeground(JBColor.foreground());
        appName.setFont(WelcomeScreenUIManager.getProductFont(36).deriveFont(0));
        appName.setHorizontalAlignment(0);
        String appVersion = "Version ";
        appVersion = appVersion + appInfo.getFullVersion();
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version2 = new JLabel(appVersion);
        version2.setFont(WelcomeScreenUIManager.getProductFont(16));
        version2.setHorizontalAlignment(0);
        version2.setForeground((Color)Gray._128);
        panel2.add((Component)appName);
        panel2.add((Component)version2, (Object)"South");
        panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        return panel2;
    }

    static JComponent createRecentProjects(Disposable parentDisposable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new NewRecentProjectPanel(parentDisposable), "Center");
        panel2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        panel2.setBorder((Border)new CustomLineBorder((Color)WelcomeScreenUIManager.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
        return panel2;
    }

    static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.ArrowDown);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        arrow.setVerticalAlignment(3);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link, (int)e.getX(), (int)e.getY());
                link.doClick((InputEvent)newEvent);
                return true;
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    static JComponent createActionLink(@NotNull Container parentContainer, @Nls String text, final String groupId2, Icon icon2, @Nullable Component focusOnLeft) {
        final Ref ref = new Ref(null);
        AnAction action2 = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId2);
                PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, configureGroup, e.getDataContext(), false, false, false, false, null, -1, null, "WelcomeScreen", new MenuItemPresentationFactory(true), false);
                popup2.showUnderneathOfLabel((JLabel)ref.get());
            }
        };
        JComponent panel2 = WelcomeScreenComponentFactory.createActionLink(text, icon2, (Ref<? super ActionLink>)ref, action2);
        WelcomeScreenFocusManager.installFocusable(parentContainer, panel2, action2, 40, 38, focusOnLeft);
        return panel2;
    }

    static JComponent createActionLink(@Nls String text, Icon icon2, Ref<? super ActionLink> ref, AnAction action2) {
        ActionLink link = new ActionLink(text, icon2, action2);
        ref.set((Object)link);
        link.setFocusable(false);
        link.setPaintUnderline(false);
        link.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
        JActionLinkPanel panel2 = new JActionLinkPanel(link);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        panel2.add((Component)WelcomeScreenComponentFactory.createArrow(link), "East");
        return panel2;
    }

    static JComponent createErrorsLink(Disposable parent) {
        IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
        panel2.setBorder((Border)JBUI.Borders.emptyRight((int)13));
        panel2.setOpaque(false);
        Disposer.register((Disposable)parent, (Disposable)panel2);
        return panel2;
    }

    public static void collectAllActions(@NotNull DefaultActionGroup group, @NotNull ActionGroup actionGroup) {
        for (AnAction action2 : actionGroup.getChildren(null)) {
            if (action2 instanceof ActionGroup && !((ActionGroup)action2).isPopup()) {
                WelcomeScreenComponentFactory.collectAllActions(group, (ActionGroup)action2);
                continue;
            }
            group.add(action2);
        }
    }

    public static String getApplicationTitle() {
        String suffix;
        String title = IdeBundle.message((String)"label.welcome.to.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (Boolean.getBoolean("ide.ui.version.in.title")) {
            title = title + ' ' + ApplicationInfo.getInstance().getFullVersion();
        }
        if ((suffix = ProjectFrameHelper.getSuperUserSuffix()) != null) {
            title = title + " (" + suffix + ")";
        }
        return title;
    }

    static boolean isActionAvailable(@NotNull AnAction action2) {
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"WelcomeScreen", (DataContext)DataContext.EMPTY_CONTEXT);
        action2.update(event);
        return event.getPresentation().isEnabledAndVisible();
    }

    @NotNull
    static ActionListener createActionListenerForComponent(@NotNull JComponent component2, @NotNull AnAction action2) {
        return l -> {
            ActionToolbar toolbar = (ActionToolbar)ComponentUtil.getParentOfType(ActionToolbar.class, (Component)component2);
            DataContext dataContext = toolbar != null ? toolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext((Component)component2);
            action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"WelcomeScreen", (DataContext)dataContext));
        };
    }

    static Couple<DefaultActionGroup> splitActionGroupToMainAndMore(@NotNull ActionGroup actionGroup, int mainButtonsNum) {
        DefaultActionGroup group = new DefaultActionGroup();
        WelcomeScreenComponentFactory.collectAllActions(group, actionGroup);
        AnAction[] actions = group.getChildren(null);
        DefaultActionGroup main2 = new DefaultActionGroup();
        DefaultActionGroup more = new DefaultActionGroup(IdeBundle.message((String)"welcome.screen.empty.projects.more.text", (Object[])new Object[0]), true){

            public boolean hideIfNoVisibleChildren() {
                return true;
            }
        };
        for (AnAction child2 : actions) {
            if (!WelcomeScreenComponentFactory.isActionAvailable(child2)) continue;
            if (main2.getChildrenCount() < mainButtonsNum) {
                main2.addAction(child2);
                continue;
            }
            more.addAction(child2);
        }
        return Couple.of((Object)main2, (Object)more);
    }

    static class LargeIconWithTextWrapper
    extends AnActionButton.AnActionButtonWrapper
    implements CustomComponentAction {
        final JButton myIconButton = new JButton();
        final JBLabel myLabel;
        private final JPanel myPanel;

        LargeIconWithTextWrapper(@NotNull AnAction action2) {
            super(action2.getTemplatePresentation(), action2);
            this.myIconButton.setBorder((Border)JBUI.Borders.empty());
            this.myIconButton.setHorizontalAlignment(0);
            this.myIconButton.setOpaque(false);
            this.myIconButton.setPreferredSize((Dimension)new JBDimension(60, 60));
            this.myIconButton.putClientProperty("JButton.focusedBackgroundColor", WelcomeScreenUIManager.getActionsButtonBackground(true));
            this.myIconButton.putClientProperty("JButton.backgroundColor", WelcomeScreenUIManager.getActionsButtonBackground(false));
            this.myIconButton.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.updateIconBackground(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.updateIconBackground(false);
                }
            });
            this.myIconButton.addActionListener(WelcomeScreenComponentFactory.createActionListenerForComponent(this.myIconButton, action2));
            Wrapper iconWrapper = new Wrapper((JComponent)this.myIconButton);
            iconWrapper.setBorder((Border)JBUI.Borders.empty((int)0, (int)30));
            this.myLabel = new JBLabel(Objects.requireNonNull(this.getTemplateText()), 0);
            this.myLabel.setOpaque(false);
            this.myPanel = new NonOpaquePanel((LayoutManager)new VerticalFlowLayout(0, 0, JBUI.scale((int)12), false, false));
            this.myPanel.add((Component)iconWrapper);
            this.myPanel.add((Component)this.myLabel);
        }

        void updateIconBackground(boolean selected2) {
            this.myIconButton.setSelected(selected2);
            this.myIconButton.putClientProperty("JButton.backgroundColor", WelcomeScreenUIManager.getActionsButtonBackground(selected2));
            this.myIconButton.repaint();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            return this.myPanel;
        }

        public void updateButton(@NotNull AnActionEvent e) {
            this.getDelegate().update(e);
            this.myIconButton.setIcon(e.getPresentation().getIcon());
            this.myIconButton.setSelectedIcon(e.getPresentation().getSelectedIcon());
            this.myLabel.setText(e.getPresentation().getText());
            UIUtil.setEnabled((Component)this.myPanel, (boolean)e.getPresentation().isEnabled(), (boolean)true);
        }

        @NotNull
        public static LargeIconWithTextWrapper wrapAsBigIconWithText(AnAction action2) {
            return new LargeIconWithTextWrapper(action2);
        }
    }

    static class ToolbarTextButtonWrapper
    extends AnActionButton.AnActionButtonWrapper
    implements CustomComponentAction {
        final JButton myButton = new JButton(this.getTemplateText());

        ToolbarTextButtonWrapper(@NotNull AnAction action2) {
            super(action2.getTemplatePresentation(), action2);
            this.myButton.setOpaque(false);
            this.myButton.addActionListener(WelcomeScreenComponentFactory.createActionListenerForComponent(this.myButton, action2));
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            return this.myButton;
        }

        public void updateButton(@NotNull AnActionEvent e) {
            this.getDelegate().update(e);
            this.myButton.setText(e.getPresentation().getText());
            this.myButton.setVisible(e.getPresentation().isVisible());
            this.myButton.setEnabled(e.getPresentation().isEnabled());
        }

        public static ToolbarTextButtonWrapper wrapAsTextButton(@NotNull AnAction action2) {
            return new ToolbarTextButtonWrapper(action2);
        }
    }

    protected static class JActionLinkPanel
    extends JPanel {
        @NotNull
        private final ActionLink myActionLink;

        public JActionLinkPanel(@NotNull ActionLink actionLink) {
            super(new BorderLayout());
            this.myActionLink = actionLink;
            this.add((Component)this.myActionLink);
            this.setOpaque(false);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
            }
            return this.accessibleContext;
        }

        protected final class AccessibleJActionLinkPanel
        extends AccessibleContextDelegate {
            private final JComponent.AccessibleJComponent myAccessibleHelper;

            AccessibleJActionLinkPanel(AccessibleContext context) {
                super(context);
                this.myAccessibleHelper = new JComponent.AccessibleJComponent(){};
            }

            public Container getDelegateParent() {
                return JActionLinkPanel.this.getParent();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }

            public int getAccessibleChildrenCount() {
                return this.myAccessibleHelper.getAccessibleChildrenCount();
            }

            public Accessible getAccessibleChild(int i2) {
                return this.myAccessibleHelper.getAccessibleChild(i2);
            }
        }
    }
}

