/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class ToolWindowsWidget
extends JLabel
implements CustomStatusBarWidget,
StatusBarWidget,
Disposable,
UISettingsListener,
PropertyChangeListener {
    private final Alarm myAlarm;
    private StatusBar myStatusBar;
    private JBPopup popup;
    private boolean wasExited = false;

    ToolWindowsWidget(@NotNull Disposable parent) {
        this.setBorder((Border)JBUI.Borders.empty());
        new BaseButtonBehavior(this, TimedDeadzone.NULL){

            protected void execute(MouseEvent e) {
                ToolWindowsWidget.this.performAction();
            }
        }.setActionTrigger(501);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof MouseEvent) {
                this.dispatchMouseEvent((MouseEvent)e);
            }
            return false;
        }, parent);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, (Object)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        this.myAlarm = new Alarm(parent);
    }

    private void dispatchMouseEvent(MouseEvent e) {
        Component component2 = e.getComponent();
        if (component2 != null && SwingUtilities.isDescendingFrom(component2, SwingUtilities.getWindowAncestor(this))) {
            int id2 = e.getID();
            if (id2 == 503 && this.isShowing()) {
                this.mouseMoved(e);
            } else if (id2 == 505) {
                this.mouseExited(e.getLocationOnScreen());
            }
        }
    }

    private void mouseMoved(MouseEvent e) {
        Point p = e.getLocationOnScreen();
        Point screen = this.getLocationOnScreen();
        if (new Rectangle(screen.x - 4, screen.y - 2, this.getWidth() + 4, this.getHeight() + 4).contains(p)) {
            this.mouseEntered();
            this.wasExited = false;
        } else if (!this.wasExited) {
            this.wasExited = this.mouseExited(p);
        }
    }

    private boolean mouseExited(Point currentLocationOnScreen) {
        this.myAlarm.cancelAllRequests();
        if (this.popup != null && this.popup.isVisible()) {
            Point screen = this.popup.getLocationOnScreen();
            Rectangle popupScreenRect = new Rectangle(screen.x, screen.y, this.popup.getSize().width, this.popup.getSize().height);
            if (!popupScreenRect.contains(currentLocationOnScreen)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> {
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.cancel();
                    }
                }, 300);
                return true;
            }
        }
        return false;
    }

    private void mouseEntered() {
        boolean active = ApplicationManager.getApplication().isActive();
        if (!active) {
            return;
        }
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
                if (project == null) {
                    return;
                }
                ArrayList<ToolWindow> toolWindows = new ArrayList<ToolWindow>();
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                for (String id2 : toolWindowManager.getToolWindowIds()) {
                    ToolWindow tw = toolWindowManager.getToolWindow(id2);
                    if (!tw.isAvailable() || !tw.isShowStripeButton()) continue;
                    toolWindows.add(tw);
                }
                toolWindows.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getStripeTitle(), (String)o2.getStripeTitle()));
                JBList list2 = new JBList(toolWindows);
                list2.setCellRenderer((ListCellRenderer)new ListCellRenderer<ToolWindow>(){
                    final JBLabel label = new JBLabel();

                    @Override
                    public Component getListCellRendererComponent(JList<? extends ToolWindow> list2, ToolWindow toolWindow, int index, boolean isSelected, boolean cellHasFocus) {
                        this.label.setText(toolWindow.getStripeTitle());
                        this.label.setIcon(toolWindow.getIcon());
                        this.label.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                        this.label.setForeground(UIUtil.getListForeground((boolean)isSelected));
                        this.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
                        JPanel panel2 = new JPanel(new BorderLayout());
                        panel2.add((Component)this.label, "Center");
                        panel2.setBackground(UIUtil.getListBackground((boolean)isSelected));
                        return panel2;
                    }
                });
                Dimension size = list2.getPreferredSize();
                ToolWindowsWidget c = this;
                Insets padding = UIUtil.getListViewportPadding();
                RelativePoint point = new RelativePoint((Component)c, new Point(-4, -padding.top - padding.bottom - 4 - size.height + (SystemInfo.isMac ? 2 : 0)));
                if (this.popup != null && this.popup.isVisible()) {
                    return;
                }
                list2.setSelectedIndex(list2.getItemsCount() - 1);
                PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2);
                this.popup = builder2.setAutoselectOnMouseMove(true).setRequestFocus(false).setItemChosenCallback(selectedValue -> {
                    if (this.popup != null) {
                        this.popup.closeOk(null);
                    }
                    selectedValue.activate(null, true, true);
                }).createPopup();
                list2.setVisibleRowCount(30);
                this.popup.show(point);
            }, 300);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateIcon();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        this.updateIcon();
    }

    private void performAction() {
        if (this.isActive()) {
            UISettings.getInstance().setHideToolStripes(!UISettings.getInstance().getHideToolStripes());
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private void updateIcon() {
        this.setToolTipText(null);
        if (this.isActive()) {
            Icon icon2;
            boolean changes = false;
            if (!this.isVisible()) {
                this.setVisible(true);
                changes = true;
            }
            Icon icon3 = icon2 = UISettings.getInstance().getHideToolStripes() ? AllIcons.General.TbShown : AllIcons.General.TbHidden;
            if (icon2 != this.getIcon()) {
                this.setIcon(icon2);
                changes = true;
            }
            if (changes) {
                this.revalidate();
                this.repaint();
            }
        } else {
            this.setVisible(false);
            this.setToolTipText(null);
        }
    }

    private boolean isActive() {
        return this.myStatusBar != null && this.myStatusBar.getProject() != null && Registry.is((String)"ide.windowSystem.showTooWindowButtonsSwitcher");
    }

    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public String ID() {
        return "ToolWindows Widget";
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
        this.myStatusBar = statusBar;
        this.updateIcon();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        this.myStatusBar = null;
        this.popup = null;
    }
}

