/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.HectorComponentFactory;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TogglePopupHintsPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    public static final String ID = "InspectionProfile";
    private Icon myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
    private String myToolTipText;

    public TogglePopupHintsPanel(@NotNull Project project) {
        super(project);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.updateStatus();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.updateStatus();
    }

    public StatusBarWidget copy() {
        return new TogglePopupHintsPanel(this.getProject());
    }

    @Nullable
    public Icon getIcon() {
        return this.myCurrentIcon;
    }

    public String getTooltipText() {
        return this.myToolTipText;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return e -> {
            PsiFile file2 = this.getCurrentFile();
            if (file2 != null) {
                if (!DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2)) {
                    return;
                }
                HectorComponent component2 = ((HectorComponentFactory)ServiceManager.getService((Project)this.myProject, HectorComponentFactory.class)).create(file2);
                component2.showComponent(e.getComponent(), (Function1<? super Dimension, ? extends Point>)((Function1)d -> new Point(-d.width, -d.height)));
            }
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        MessageBusConnection connection = this.myConnection;
        connection.subscribe(PowerSaveMode.TOPIC, this::updateStatus);
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profilesInitialized() {
                TogglePopupHintsPanel.this.updateStatus();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                TogglePopupHintsPanel.this.updateStatus();
            }

            public void profileChanged(InspectionProfile profile) {
                TogglePopupHintsPanel.this.updateStatus();
            }
        });
        connection.subscribe(FileHighlightingSettingListener.SETTING_CHANGE, (__, ___) -> this.updateStatus());
        this.updateStatus();
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void clear() {
        this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
        this.myToolTipText = null;
        this.myStatusBar.updateWidget(this.ID());
    }

    public void updateStatus() {
        AppUIUtil.invokeOnEdt(() -> this.updateStatus(this.getCurrentFile()));
    }

    private void updateStatus(PsiFile file2) {
        if (this.isDisposed()) {
            return;
        }
        if (TogglePopupHintsPanel.isStateChangeable(file2)) {
            if (PowerSaveMode.isEnabled()) {
                this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
                this.myToolTipText = "Code analysis is disabled in power save mode.\n";
            } else if (HighlightingLevelManager.getInstance(this.getProject()).shouldInspect((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorOn;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(file2.getProject()).getCurrentProfile();
                if (profile.wasInitialized()) {
                    this.myToolTipText = "Current inspection profile: " + profile.getName() + ".\n";
                }
            } else if (HighlightingLevelManager.getInstance(this.getProject()).shouldHighlight((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorSyntax;
                this.myToolTipText = "Highlighting level is: Syntax.\n";
            } else {
                this.myCurrentIcon = AllIcons.Ide.HectorOff;
                this.myToolTipText = "Inspections are off.\n";
            }
            this.myToolTipText = this.myToolTipText + UIBundle.message((String)"popup.hints.panel.click.to.configure.highlighting.tooltip.text", (Object[])new Object[0]);
        } else {
            this.myCurrentIcon = file2 != null ? IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff) : null;
            this.myToolTipText = null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static boolean isStateChangeable(PsiFile file2) {
        return file2 != null && DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile != null && virtualFile.isValid()) {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        return null;
    }
}

