/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class ProcessPopup {
    public static final Key<ProgressPanel> KEY = new Key("ProgressPanel");
    private final InfoAndProgressPanel myProgressPanel;
    private final JPanel myIndicatorPanel;
    private final JScrollPane myContentPanel;
    private JBPopup myPopup;

    ProcessPopup(@NotNull InfoAndProgressPanel progressPanel) {
        this.myProgressPanel = progressPanel;
        this.myIndicatorPanel = new JBPanelWithEmptyText().withEmptyText(IdeBundle.message((String)"progress.window.empty.text", (Object[])new Object[0])).andTransparent();
        this.myIndicatorPanel.setLayout((LayoutManager)new VerticalLayout(0));
        this.myIndicatorPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)18, (int)0));
        this.myIndicatorPanel.setFocusable(true);
        this.myContentPanel = new JBScrollPane(this.myIndicatorPanel, 20, 31){

            public Dimension getPreferredSize() {
                if (ProcessPopup.this.myIndicatorPanel.getComponentCount() > 0) {
                    return super.getPreferredSize();
                }
                return ProcessPopup.getEmptyPreferredSize();
            }
        };
        this.updateContentUI();
    }

    public void addIndicator(@NotNull InlineProgressIndicator indicator) {
        JComponent component2 = indicator.getComponent();
        if (this.myIndicatorPanel.getComponentCount() == 0) {
            ProcessPopup.hideSeparator(component2);
        }
        this.myIndicatorPanel.add(component2);
        this.revalidateAll();
    }

    public void removeIndicator(@NotNull InlineProgressIndicator indicator) {
        JComponent component2 = indicator.getComponent();
        int index = this.myIndicatorPanel.getComponentZOrder(component2);
        if (index == -1) {
            return;
        }
        this.myIndicatorPanel.remove(component2);
        if (index == 0 && this.myIndicatorPanel.getComponentCount() > 0) {
            ProcessPopup.hideSeparator(this.myIndicatorPanel.getComponent(0));
        }
        this.revalidateAll();
    }

    public void show(boolean requestFocus) {
        this.updateContentUI();
        this.createPopup(this.myContentPanel, this.myIndicatorPanel, requestFocus);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myPopup).subscribe(LafManagerListener.TOPIC, source -> this.updateContentUI());
        JFrame frame = (JFrame)UIUtil.findUltimateParent((Component)this.myProgressPanel);
        Dimension contentSize = this.myContentPanel.getPreferredSize();
        Rectangle bounds2 = frame.getBounds();
        int width = Math.max(bounds2.width / 4, contentSize.width);
        int height = Math.min(bounds2.height / 4, contentSize.height);
        this.myContentPanel.setPreferredSize(new Dimension(width, height));
        int x = bounds2.x + bounds2.width - width - JBUI.scale((int)20);
        int y = bounds2.y + bounds2.height - height - JBUI.scale((int)40);
        StatusBarEx sb = (StatusBarEx)((IdeFrame)frame).getStatusBar();
        if (sb != null && sb.isVisible()) {
            y -= sb.getSize().height;
        }
        this.myPopup.showInScreenCoordinates((Component)this.myProgressPanel.getRootPane(), new Point(x, y));
    }

    public boolean isShowing() {
        return this.myPopup != null;
    }

    public void hide() {
        if (this.myPopup != null) {
            JBPopup popup2 = this.myPopup;
            this.myPopup = null;
            popup2.cancel();
        }
    }

    private void revalidateAll() {
        this.myContentPanel.doLayout();
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private void updateContentUI() {
        IJSwingUtilities.updateComponentTreeUI(this.myContentPanel);
        this.myContentPanel.getViewport().setBackground(this.myIndicatorPanel.getBackground());
        this.myContentPanel.setBorder(null);
    }

    private static void hideSeparator(@NotNull Component component2) {
        ((ProgressPanel)UIUtil.getClientProperty((Object)component2, KEY)).setSeparatorEnabled(false);
    }

    @NotNull
    private static Dimension getEmptyPreferredSize() {
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = (int)((double)size.width * 0.3);
        size.height = (int)((double)size.height * 0.3);
        return size;
    }

    private void createPopup(@NotNull JComponent content2, @NotNull JComponent focus, boolean requestFocus) {
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(content2, focus);
        builder2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                ProcessPopup.this.myProgressPanel.hideProcessPopup();
            }
        });
        builder2.setMovable(true);
        builder2.setResizable(true);
        builder2.setTitle(IdeBundle.message((String)"progress.window.title", (Object[])new Object[0]));
        builder2.setDimensionServiceKey(null, "ProcessPopupWindow", true);
        builder2.setCancelOnClickOutside(false);
        builder2.setRequestFocus(requestFocus);
        builder2.setBelongsToGlobalPopupStack(false);
        builder2.setLocateByContent(true);
        builder2.setMinSize((Dimension)new JBDimension(300, 100));
        builder2.setCancelButton((IconButton)new MinimizeButton("Hide"));
        this.myPopup = builder2.addUserData((Object)"SIMPLE_WINDOW").createPopup();
        this.myPopup.getContent().putClientProperty("FirstTimeSize", new JBDimension(300, 0));
    }
}

