/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.ui.UIBundle;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineSeparatorPanel
extends EditorBasedStatusBarPopup {
    protected LineSeparatorPanel(@NotNull Project project) {
        super(project, true);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file2, this.getProject());
        String toolTipText = "Line Separator: " + StringUtil.escapeLineBreak((String)lineSeparator);
        String panelText = LineSeparator.fromString((String)lineSeparator).toString();
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, panelText, true);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        AnAction group = ActionManager.getInstance().getAction("ChangeLineSeparators");
        if (!(group instanceof ActionGroup)) {
            return null;
        }
        return JBPopupFactory.getInstance().createActionGroupPopup(UIBundle.message((String)"status.bar.line.separator.widget.name", (Object[])new Object[0]), (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new LineSeparatorPanel(project);
    }

    @NotNull
    public String ID() {
        return "LineSeparator";
    }
}

