/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowHeaderKt;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.ui.layout.migLayout.patched.MigLayout;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PanelUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u000289B%\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u0004\u0018\u00010\u0018J\b\u0010'\u001a\u00020\u001cH$J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014J\u0014\u0010+\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\u0019\u0010/\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.00\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u000207H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader;", "Ljavax/swing/JPanel;", "Lcom/intellij/ide/ui/UISettingsListener;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "contentUi", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "gearProducer", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;Ljava/util/function/Supplier;)V", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "actionGroupWest", "activeImage", "Ljava/awt/image/BufferedImage;", "image", "imageType", "Lcom/intellij/openapi/wm/ToolWindowType;", "isActive", "", "()Z", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "toolbarWest", "westPanel", "clearCaches", "", "getComponentGraphics", "Ljava/awt/Graphics;", "g", "getData", "", "dataId", "", "getPreferredSize", "Ljava/awt/Dimension;", "getToolbar", "hideToolWindow", "initWestToolBar", "paintChildren", "paintComponent", "setAdditionalTitleActions", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "setTabActions", "", "([Lcom/intellij/openapi/actionSystem/AnAction;)V", "setUI", "ui", "Ljavax/swing/plaf/PanelUI;", "uiSettingsChanged", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "HideAction", "ShowOptionsAction", "intellij.platform.ide.impl"})
public abstract class ToolWindowHeader
extends JPanel
implements UISettingsListener,
DataProvider {
    private BufferedImage image;
    private BufferedImage activeImage;
    private ToolWindowType imageType;
    private final DefaultActionGroup actionGroup;
    private final DefaultActionGroup actionGroupWest;
    private final ActionToolbar toolbar;
    private ActionToolbar toolbarWest;
    private final JPanel westPanel;
    private final ToolWindowImpl toolWindow;
    private final ToolWindowContentUi contentUi;
    private final Supplier<ActionGroup> gearProducer;

    @Nullable
    public final ActionToolbar getToolbar() {
        return this.toolbar;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (MorePopupAware.KEY.is(dataId)) {
            return this.contentUi.getData(dataId);
        }
        return null;
    }

    private final void initWestToolBar(JPanel westPanel) {
        ActionToolbar actionToolbar = this.toolbarWest = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)this.actionGroupWest}), true);
        if (actionToolbar == null) {
            Intrinsics.throwNpe();
        }
        actionToolbar.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar2 = this.toolbarWest;
        if (actionToolbar2 == null) {
            Intrinsics.throwNpe();
        }
        actionToolbar2.setLayoutPolicy(0);
        ActionToolbar actionToolbar3 = this.toolbarWest;
        if (actionToolbar3 == null) {
            Intrinsics.throwNpe();
        }
        actionToolbar3.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar4 = this.toolbarWest;
        if (actionToolbar4 == null) {
            Intrinsics.throwNpe();
        }
        JComponent component2 = actionToolbar4.getComponent();
        component2.setOpaque(false);
        component2.setBorder((Border)JBUI.Borders.empty());
        westPanel.add(component2);
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        this.clearCaches();
    }

    public final void setTabActions(@NotNull AnAction[] actions) {
        block1: {
            if (this.toolbarWest == null) {
                this.initWestToolBar(this.westPanel);
            }
            this.actionGroupWest.removeAll();
            this.actionGroupWest.addSeparator();
            this.actionGroupWest.addAll(Arrays.copyOf(actions, actions.length));
            ActionToolbar actionToolbar = this.toolbarWest;
            if (actionToolbar == null) break block1;
            actionToolbar.updateActionsImmediately();
        }
    }

    public final void setAdditionalTitleActions(@NotNull List<? extends AnAction> actions) {
        this.actionGroup.removeAll();
        this.actionGroup.addAll((Collection)actions);
        Collection collection = actions;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.actionGroup.addSeparator();
        }
        this.toolbar.updateActionsImmediately();
    }

    @Override
    @NotNull
    protected Graphics getComponentGraphics(@NotNull Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Rectangle r = this.getBounds();
        Graphics graphics = g;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        Shape clip = g2d.getClip();
        ToolWindowType type = this.toolWindow.getType();
        Image image = null;
        if (this.isActive()) {
            if (this.activeImage == null || type != this.imageType) {
                this.activeImage = ToolWindowHeaderKt.access$drawToBuffer(g2d, true, r.height, type == ToolWindowType.FLOATING);
            }
            image = this.activeImage;
        } else {
            if (this.image == null || type != this.imageType) {
                this.image = ToolWindowHeaderKt.access$drawToBuffer(g2d, false, r.height, type == ToolWindowType.FLOATING);
            }
            image = this.image;
        }
        this.imageType = type;
        Rectangle clipBounds = clip.getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            Image image2 = image;
            if (image2 == null) {
                Intrinsics.throwNpe();
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)image2, (int)x, (int)0, null);
        }
    }

    @Override
    public void setUI(@NotNull PanelUI ui) {
        this.clearCaches();
        super.setUI(ui);
    }

    public final void clearCaches() {
        this.image = null;
        this.activeImage = null;
    }

    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2 = (Graphics2D)graphics;
        UISettings.Companion.setupAntialiasing((Graphics)graphics2);
        super.paintChildren(graphics2);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !StartupUiUtil.isUnderDarcula()) {
            graphics2.setColor(new Color(255, 255, 255, 30));
            graphics2.fill(r);
        }
        graphics2.dispose();
    }

    protected abstract boolean isActive();

    protected abstract void hideToolWindow();

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Insets insets = this.getInsets();
        int height = JBUI.scale((int)28) - insets.top - insets.bottom;
        return new Dimension(size.width, height);
    }

    public ToolWindowHeader(@NotNull ToolWindowImpl toolWindow, @NotNull ToolWindowContentUi contentUi, @NotNull Supplier<ActionGroup> gearProducer) {
        super(new MigLayout(MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fill(), ConstraintParser.parseColumnConstraints((String)"[grow][pref!]"), null, 4, null));
        this.toolWindow = toolWindow;
        this.contentUi = contentUi;
        this.gearProducer = gearProducer;
        this.actionGroup = new DefaultActionGroup();
        this.actionGroupWest = new DefaultActionGroup();
        AccessibleContextUtil.setName((Component)this, (String)"Tool Window Header");
        this.westPanel = new JPanel(new MigLayout(MigLayoutUtilKt.createLayoutConstraints(0, 0).noVisualPadding().fillY(), null, null, 6, null));
        this.westPanel.setOpaque(false);
        this.westPanel.add((Component)this.contentUi.getTabComponent(), new CC().growY());
        this.add((Component)this.westPanel, new CC().grow());
        ToolWindowContentUi.initMouseListeners(this.westPanel, this.contentUi, true);
        this.toolbar = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DumbAware(){
            private final Lazy children$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AnAction[]>(this){
                final /* synthetic */ 1 this$0;

                @NotNull
                public final AnAction[] invoke() {
                    AnAction tabListAction = ActionManager.getInstance().getAction("TabList");
                    return new AnAction[]{tabListAction, (AnAction)ToolWindowHeader.access$getActionGroup$p(this.this$0.this), (AnAction)new ShowOptionsAction(), (AnAction)new HideAction()};
                }
                {
                    this.this$0 = var1_1;
                    super(0);
                }
            }));

            private final AnAction[] getChildren() {
                Lazy lazy = this.children$delegate;
                1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return (AnAction[])lazy.getValue();
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                return this.getChildren();
            }

            public boolean isDumbAware() {
                return true;
            }
        }, true);
        this.toolbar.setTargetComponent((JComponent)this);
        this.toolbar.setLayoutPolicy(0);
        this.toolbar.setReservePlaceAutoPopupIcon(false);
        JComponent component2 = this.toolbar.getComponent();
        component2.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        component2.setOpaque(false);
        this.add(component2);
        this.westPanel.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                contentUi.showContextMenu(comp, x, y, toolWindow.getPopupGroup(), contentUi.getContentManager().getSelectedContent());
            }
        });
        this.westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                toolWindow.fireActivated();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e.isPopupTrigger()) {
                    return;
                }
                if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                    if (e.isAltDown()) {
                        toolWindow.fireHidden();
                    } else {
                        toolWindow.fireHiddenSide();
                    }
                } else {
                    toolWindow.fireActivated();
                }
            }
        });
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)0));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                ToolWindowManagerImpl manager = toolWindow.getToolWindowManager();
                manager.setMaximized(toolWindow, !manager.isMaximized(toolWindow));
                return true;
            }
        }.installOn((Component)this.westPanel);
        this.westPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Runnable runnable2 = new Runnable(this, e){
                    final /* synthetic */ 6 this$0;
                    final /* synthetic */ MouseEvent $e;

                    public final void run() {
                        this.this$0.this.dispatchEvent(SwingUtilities.convertMouseEvent(this.$e.getComponent(), this.$e, this.this$0.this));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$e = mouseEvent;
                    }
                };
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    public static final /* synthetic */ DefaultActionGroup access$getActionGroup$p(ToolWindowHeader $this) {
        return $this.actionGroup;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader$ShowOptionsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/wm/impl/ToolWindowHeader;)V", "myPopupState", "Lcom/intellij/ui/popup/util/PopupState;", "getMyPopupState", "()Lcom/intellij/ui/popup/util/PopupState;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
    private final class ShowOptionsAction
    extends DumbAwareAction {
        @NotNull
        private final PopupState myPopupState = new PopupState();

        @NotNull
        public final PopupState getMyPopupState() {
            return this.myPopupState;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            InputEvent inputEvent = e.getInputEvent();
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)ToolWindowHeader.this.gearProducer.get());
            int x = 0;
            int y = 0;
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            popupMenu.getComponent().addPopupMenuListener((PopupMenuListener)this.myPopupState);
            popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
        }

        public ShowOptionsAction() {
            this.copyFrom((AnAction)ToolWindowHeader.this.gearProducer.get());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowHeader$HideAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/wm/impl/ToolWindowHeader;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "intellij.platform.ide.impl"})
    private final class HideAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            ToolWindowHeader.this.hideToolWindow();
        }

        public void update(@NotNull AnActionEvent event) {
            event.getPresentation().setEnabled(ToolWindowHeader.this.toolWindow.isVisible());
        }

        public HideAction() {
            ActionUtil.copyFrom((AnAction)((AnAction)this), (String)"HideActiveWindow");
            this.getTemplatePresentation().setIcon(AllIcons.General.HideToolWindow);
            this.getTemplatePresentation().setText((Supplier)1.INSTANCE);
        }
    }
}

