/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.GlobalMenuLib;
import com.intellij.openapi.wm.impl.LinuxGlobalMenuEventHandler;
import com.intellij.openapi.wm.impl.X11KeyCodes;
import com.intellij.util.loader.NativeLibraryLoader;
import com.intellij.util.ui.ImageUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.peer.ComponentPeer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GlobalMenuLinux
implements LinuxGlobalMenuEventHandler,
Disposable {
    private static final String TOGGLE_SWING_MENU_ACTION_NAME = "Toggle Global Menu Integration";
    private static final String TOGGLE_SWING_MENU_ACTION_DESC = "Enable/disable global menu integration (in all frames)";
    private static final String TOGGLE_SWING_MENU_ACTION_ID = "ToggleGlobalLinuxMenu";
    private static final SimpleDateFormat ourDtf = new SimpleDateFormat("hhmmss.SSS");
    private static final boolean TRACE_SYSOUT = Boolean.getBoolean("linux.native.menu.debug.trace.sysout");
    private static final boolean TRACE_ENABLED = Boolean.getBoolean("linux.native.menu.debug.trace.enabled");
    private static final boolean TRACE_SYNC_STATS = Boolean.getBoolean("linux.native.menu.debug.trace.sync-stats");
    private static final boolean TRACE_EVENTS = Boolean.getBoolean("linux.native.menu.debug.trace.events");
    private static final boolean TRACE_EVENT_FILTER = Boolean.getBoolean("linux.native.menu.debug.trace.event-filter");
    private static final boolean TRACE_SKIPPED_EVENT = Boolean.getBoolean("linux.native.menu.debug.trace.skipped.event");
    private static final boolean TRACE_CLEARING = Boolean.getBoolean("linux.native.menu.debug.trace.clearing");
    private static final boolean TRACE_HIERARCHY_MISMATCHES = Boolean.getBoolean("linux.native.menu.debug.trace.hierarchy.mismatches");
    private static final boolean SHOW_SWING_MENU = Boolean.getBoolean("linux.native.menu.debug.show.frame.menu");
    private static final boolean KDE_DISABLE_ROOT_MNEMONIC_PROCESSING = Boolean.getBoolean("linux.native.menu.kde.disable.root.mnemonic");
    private static final boolean SKIP_OPEN_MENU_COMMAND = Boolean.getBoolean("linux.native.menu.skip.open");
    private static final boolean DO_FILL_ROOTS = Boolean.getBoolean("linux.native.do.fill.roots");
    private static final boolean DONT_FILL_SUBMENU = Boolean.getBoolean("linux.native.menu.dont.fill.submenu");
    private static final boolean DONT_CLOSE_POPUPS = Boolean.getBoolean("linux.native.menu.dont.close.popups");
    private static final boolean DISABLE_EVENTS_FILTERING = Boolean.getBoolean("linux.native.menu.disable.events.filtering");
    private static final Logger LOG = Logger.getInstance(GlobalMenuLinux.class);
    private static final GlobalMenuLib ourLib;
    private static final GlobalMenuLib.JLogger ourGLogger;
    private static final GlobalMenuLib.JRunnable ourUpdateAllRoots;
    private static final GlobalMenuLib.JRunnable ourOnAppmenuServiceAppeared;
    private static final GlobalMenuLib.JRunnable ourOnAppmenuServiceVanished;
    private static final Map<Long, GlobalMenuLinux> ourInstances;
    private static boolean ourIsServiceAvailable;
    private final long myXid;
    @NotNull
    private final JFrame myFrame;
    private List<MenuItemInternal> myRoots;
    private Pointer myWindowHandle;
    private boolean myIsRootsUpdated = false;
    private boolean myIsEnabled = true;
    private boolean myIsDisposed = false;
    private boolean myIsFirstFilling = true;
    private final GlobalMenuLib.JRunnable myOnWindowReleased;
    private final EventFilter myEventFilter = new EventFilter();
    private static final int STAT_CREATED = 0;
    private static final int STAT_DELETED = 1;
    private static final int STAT_UPDATED = 2;

    public static GlobalMenuLinux create(@NotNull JFrame frame) {
        long xid = GlobalMenuLinux._getX11WindowXid(frame);
        return xid == 0L ? null : new GlobalMenuLinux(xid, frame);
    }

    private GlobalMenuLinux(long xid, @NotNull JFrame frame) {
        LOG.info("created instance of GlobalMenuLinux for xid=0x" + Long.toHexString(xid));
        this.myXid = xid;
        this.myFrame = frame;
        this.myOnWindowReleased = () -> {
            this.myWindowHandle = null;
            if (this.myRoots != null) {
                for (MenuItemInternal root : this.myRoots) {
                    root.nativePeer = null;
                    root.children.clear();
                }
            }
            if (this.myIsDisposed) {
                ourInstances.remove(this.myXid);
            }
        };
        if (SystemInfo.isKDE && !KDE_DISABLE_ROOT_MNEMONIC_PROCESSING) {
            IdeEventQueue.getInstance().addDispatcher(e -> {
                if (!(e instanceof KeyEvent)) {
                    return false;
                }
                KeyEvent event = (KeyEvent)e;
                if (!event.isAltDown()) {
                    return false;
                }
                Component src = event.getComponent();
                Window wndParent = src instanceof Window ? (Window)src : SwingUtilities.windowForComponent(src);
                char eventChar = Character.toUpperCase(event.getKeyChar());
                for (GlobalMenuLinux gml : ourInstances.values()) {
                    if (gml.myFrame != wndParent) continue;
                    for (MenuItemInternal root : gml.myRoots) {
                        if (eventChar != root.mnemonic) continue;
                        ourLib.showMenuItem(root.nativePeer);
                        return false;
                    }
                    return false;
                }
                return false;
            }, this);
        }
        ourInstances.put(this.myXid, this);
    }

    public void dispose() {
        if (ourLib == null || this.myIsDisposed) {
            return;
        }
        this.myIsDisposed = true;
        if (this.myWindowHandle != null) {
            GlobalMenuLinux._trace("dispose frame, scheduled destroying of GlobalMenuLinux for xid=0x%X", this.myXid);
            ourLib.releaseWindowOnMainLoop(this.myWindowHandle, this.myOnWindowReleased);
        }
    }

    public void bindNewWindow(@NotNull Window frame) {
        if (ourLib == null) {
            return;
        }
        long xid = GlobalMenuLinux._getX11WindowXid(frame);
        if (xid == 0L) {
            LOG.warn("can't obtain XID of window: " + frame + ", skip global menu binding");
            return;
        }
        if (this.myWindowHandle != null) {
            GlobalMenuLinux._trace("bind new window 0x%X", xid);
            ourLib.bindNewWindow(this.myWindowHandle, xid);
        }
    }

    public void unbindWindow(@NotNull Window frame) {
        if (ourLib == null) {
            return;
        }
        long xid = GlobalMenuLinux._getX11WindowXid(frame);
        if (xid == 0L) {
            LOG.warn("can't obtain XID of window: " + frame + ", skip global menu unbinding");
            return;
        }
        if (this.myWindowHandle != null) {
            GlobalMenuLinux._trace("unbind window 0x%X", xid);
            ourLib.unbindWindow(this.myWindowHandle, xid);
        }
    }

    public void setRoots(List<ActionMenu> roots) {
        if (ourLib == null) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int[] stats = new int[]{0, 0, 0};
        int size = roots == null ? 0 : roots.size();
        ArrayList<MenuItemInternal> newRoots = new ArrayList<MenuItemInternal>(size);
        if (roots != null) {
            for (ActionMenu am : roots) {
                int uid = System.identityHashCode((Object)am);
                MenuItemInternal mi = new MenuItemInternal(null, newRoots.size(), uid, 1, am.getAnAction());
                mi.jitem = am;
                mi.setLabelFromSwingPeer((JMenuItem)((Object)am));
                newRoots.add(mi);
                if (!DO_FILL_ROOTS) continue;
                long startMs = System.currentTimeMillis();
                am.removeAll();
                am.fillMenu();
                GlobalMenuLinux._syncChildren(mi, am, 1, stats);
                am.removeAll();
                long elapsedMs = System.currentTimeMillis() - startMs;
                if (!TRACE_SYNC_STATS) continue;
                GlobalMenuLinux._trace("filled root menu '%s', spent (in EDT) %d ms, stats: %s", String.valueOf(mi.txt), elapsedMs, GlobalMenuLinux._stats2str(stats));
            }
        }
        this.myRoots = newRoots;
        GlobalMenuLinux._trace("set new menu roots, count=%d", size);
        this.myIsRootsUpdated = false;
        ourLib.execOnMainLoop(ourUpdateAllRoots);
    }

    private void _updateRoots() {
        if (this.myIsRootsUpdated || !this.myIsEnabled || this.myIsDisposed) {
            return;
        }
        this.myIsRootsUpdated = true;
        if (this.myWindowHandle == null) {
            this.myWindowHandle = ourLib.registerWindow(this.myXid, this);
            if (this.myWindowHandle == null) {
                LOG.error("AppMenu-service can't register xid " + this.myXid);
                return;
            }
        }
        ourLib.clearRootMenu(this.myWindowHandle);
        List<MenuItemInternal> croots = this.myRoots;
        if (croots == null || croots.isEmpty()) {
            return;
        }
        for (MenuItemInternal mi : croots) {
            mi.nativePeer = ourLib.addRootMenu(this.myWindowHandle, mi.uid, mi.txt);
            GlobalMenuLinux._processChildren(mi);
        }
        if (!SHOW_SWING_MENU) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myIsEnabled) {
                    this.myFrame.getJMenuBar().setVisible(false);
                }
            });
        }
    }

    public void toggle(boolean enabled) {
        if (ourLib == null || this.myIsDisposed) {
            return;
        }
        if (this.myIsEnabled == enabled) {
            return;
        }
        this.myIsEnabled = enabled;
        if (enabled) {
            GlobalMenuLinux._trace("enable global-menu");
            this.myIsRootsUpdated = false;
            ourLib.execOnMainLoop(ourUpdateAllRoots);
        } else {
            JMenuBar frameMenu;
            if (this.myWindowHandle != null) {
                GlobalMenuLinux._trace("disable global menu, scheduled destroying of GlobalMenuLinux for xid=0x%X", this.myXid);
                ourLib.releaseWindowOnMainLoop(this.myWindowHandle, this.myOnWindowReleased);
            }
            if (UISettings.getInstance().getShowMainMenu() && (frameMenu = this.myFrame.getJMenuBar()) != null) {
                frameMenu.setVisible(true);
            }
        }
    }

    private MenuItemInternal _findMenuItem(int uid) {
        return GlobalMenuLinux._findMenuItem(this.myRoots, uid);
    }

    private static MenuItemInternal _findMenuItem(List<? extends MenuItemInternal> kids, int uid) {
        if (kids == null || kids.isEmpty()) {
            return null;
        }
        for (MenuItemInternal menuItemInternal : kids) {
            if (menuItemInternal.uid == uid) {
                return menuItemInternal;
            }
            MenuItemInternal child2 = GlobalMenuLinux._findMenuItem(menuItemInternal.children, uid);
            if (child2 == null) continue;
            return child2;
        }
        return null;
    }

    private static String _evtype2str(int eventType) {
        switch (eventType) {
            case 0: {
                return "event-opened";
            }
            case 1: {
                return "event-closed";
            }
            case 2: {
                return "event-clicked";
            }
            case 4: {
                return "signal-about-to-show";
            }
            case 3: {
                return "signal-activated";
            }
            case 6: {
                return "signal-child-added";
            }
            case 5: {
                return "signal-shown";
            }
        }
        return "unknown-event-type-" + eventType;
    }

    private static byte[] _icon2png(Icon icon2) {
        if (icon2 == null || icon2.getIconWidth() <= 0 || icon2.getIconHeight() <= 0) {
            return null;
        }
        BufferedImage img = ImageUtil.createImage((int)icon2.getIconWidth(), (int)icon2.getIconHeight(), (int)2);
        Graphics2D g2d = img.createGraphics();
        icon2.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static MenuItemInternal _createInternalFromSwing(MenuItemInternal parent, Component each) {
        if (each == null) {
            return null;
        }
        MenuItemInternal result2 = null;
        if (each instanceof ActionMenuItem) {
            ActionMenuItem ami = (ActionMenuItem)((Object)each);
            result2 = new MenuItemInternal(parent, -1, System.identityHashCode((Object)ami), ami.isToggleable() ? 2 : 0, ami.getAnAction());
            result2.jitem = ami;
        } else if (each instanceof ActionMenu) {
            ActionMenu am2 = (ActionMenu)((Object)each);
            result2 = new MenuItemInternal(parent, -1, System.identityHashCode((Object)am2), 1, am2.getAnAction());
            result2.jitem = am2;
        } else if (each instanceof JSeparator) {
            result2 = new MenuItemInternal(parent, -1, System.identityHashCode(each), 0, null);
        } else if (!(each instanceof StubItem)) {
            LOG.error("unknown type of menu-item, class: " + each.getClass());
        }
        return result2;
    }

    private static String _stats2str(int[] stats) {
        if (stats == null) {
            return "empty";
        }
        return String.format("created=%d, deleted=%d, updated=%d", stats[0], stats[1], stats[2]);
    }

    private static void _syncChildren(@NotNull MenuItemInternal mi, @NotNull ActionMenu am, int deepness, int[] stats) {
        mi.clearChildrenSwingRefs();
        for (MenuItemInternal cmi : mi.children) {
            cmi.position = -1;
        }
        if (stats != null) {
            stats[1] = stats[1] + mi.children.size();
        }
        int itemPos = 0;
        for (Component each : am.getPopupMenu().getComponents()) {
            MenuItemInternal cmi = mi.findCorrespondingChild(each);
            if (cmi == null) {
                cmi = GlobalMenuLinux._createInternalFromSwing(mi, each);
                if (cmi != null) {
                    cmi.position = itemPos++;
                    mi.children.add(cmi);
                    if (stats != null) {
                        stats[0] = stats[0] + 1;
                    }
                    if (each instanceof JMenuItem) {
                        cmi.updateBySwingPeer((JMenuItem)each);
                    }
                }
            } else {
                cmi.position = itemPos++;
                if (stats != null) {
                    stats[1] = stats[1] - 1;
                }
                if (each instanceof JMenuItem) {
                    boolean changed2 = cmi.updateBySwingPeer((JMenuItem)each);
                    if (stats != null && changed2) {
                        stats[2] = stats[2] + 1;
                    }
                }
            }
            if (cmi == null || deepness <= 1 || !(each instanceof ActionMenu)) continue;
            ActionMenu jmiEach = (ActionMenu)((Object)each);
            jmiEach.removeAll();
            jmiEach.fillMenu();
            GlobalMenuLinux._syncChildren(cmi, jmiEach, deepness - 1, stats);
        }
    }

    private static void _processChildren(@NotNull MenuItemInternal mi) {
        if (mi.nativePeer == null) {
            return;
        }
        mi.children.sort(Comparator.comparingInt(MenuItemInternal::getPosition));
        Iterator<MenuItemInternal> i2 = mi.children.iterator();
        while (i2.hasNext()) {
            MenuItemInternal child2 = i2.next();
            if (child2.position != -1) break;
            if (child2.nativePeer != null) {
                ourLib.removeMenuItem(mi.nativePeer, child2.nativePeer);
                child2.nativePeer = null;
            }
            i2.remove();
        }
        for (int pos = 0; pos < mi.children.size(); ++pos) {
            MenuItemInternal child3 = mi.children.get(pos);
            if (child3.nativePeer == null) {
                if (child3.action == null) {
                    child3.nativePeer = ourLib.addSeparator(mi.nativePeer, child3.uid, pos);
                    continue;
                }
                child3.nativePeer = ourLib.addMenuItem(mi.nativePeer, child3.uid, child3.txt, child3.type, child3.position);
            } else if (child3.position != pos) {
                ourLib.reorderMenuItem(mi.nativePeer, child3.nativePeer, child3.position);
            }
            child3.updateNative();
            GlobalMenuLinux._processChildren(child3);
        }
    }

    private static boolean _isFillEvent(int eventType) {
        return eventType == 4 || !SKIP_OPEN_MENU_COMMAND && eventType == 0;
    }

    @Override
    public void handleEvent(int uid, int eventType) {
        this._handleEvent(uid, eventType, true);
    }

    private void _handleEvent(int uid, int eventType, boolean doFiltering) {
        if (this.myWindowHandle == null || this.myIsDisposed) {
            if (TRACE_ENABLED) {
                GlobalMenuLinux._trace("window was closed when received event '%s', just skip it", GlobalMenuLinux._evtype2str(eventType));
            }
            return;
        }
        MenuItemInternal mi = this._findMenuItem(uid);
        if (mi == null) {
            LOG.error("can't find menu-item by uid " + uid + ", eventType=" + eventType);
            return;
        }
        if (mi.nativePeer == null) {
            LOG.error("menu-item hasn't native peer, uid = " + uid + ", eventType=" + eventType);
            return;
        }
        if (mi.action == null) {
            LOG.error("menu-item hasn't associated AnAction, uid = " + uid + ", eventType=" + eventType);
            return;
        }
        if (TRACE_EVENTS) {
            GlobalMenuLinux._trace("received event '%s' from item %s", GlobalMenuLinux._evtype2str(eventType), mi);
        }
        if (!DISABLE_EVENTS_FILTERING && !this.myIsFirstFilling && doFiltering && !this.myEventFilter.check(uid, eventType, mi)) {
            return;
        }
        if (this.myIsFirstFilling) {
            Timer timer2 = new Timer(5000, e -> {
                this.myIsFirstFilling = false;
            });
            timer2.setRepeats(false);
            timer2.start();
        }
        if (GlobalMenuLinux._isFillEvent(eventType)) {
            if (!DONT_CLOSE_POPUPS) {
                ApplicationManager.getApplication().invokeLater(() -> IdeEventQueue.getInstance().getPopupManager().closeAllPopups());
            }
            mi.cancelClearSwing();
            long timeMs = System.currentTimeMillis();
            int[] stats = new int[]{0, 0, 0};
            if (timeMs - mi.lastFilledMs < 1500L && mi.lastClearedMs < mi.lastFilledMs) {
                if (TRACE_SKIPPED_EVENT) {
                    GlobalMenuLinux._trace("skipped fill-event for item '%s', use cached (too frequent fill-events)", String.valueOf(mi.txt));
                }
            } else {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    JMenuItem jmi = mi.jitem;
                    if (jmi == null) {
                        if (TRACE_HIERARCHY_MISMATCHES) {
                            GlobalMenuLinux._trace("corresponding (opening) swing item is null, event source: " + mi + ", swing menu hierarchy:\n" + this._dumpSwingHierarchy());
                        }
                        return;
                    }
                    if (!(jmi instanceof ActionMenu)) {
                        LOG.error("corresponding (opening) swing item isn't instance of ActionMenu, class=" + jmi.getClass().getName() + ", event source: " + mi);
                        return;
                    }
                    mi.lastFilledMs = timeMs;
                    ActionMenu am = (ActionMenu)((Object)((Object)jmi));
                    am.removeAll();
                    am.fillMenu();
                    GlobalMenuLinux._syncChildren(mi, am, DONT_FILL_SUBMENU ? 1 : 2, stats);
                });
                long elapsedMs = System.currentTimeMillis() - timeMs;
                if (TRACE_SYNC_STATS) {
                    GlobalMenuLinux._trace("filled menu %s '%s', spent (in EDT) %d ms, stats: %s", mi.isRoot() ? "root menu" : "submenu", String.valueOf(mi.txt), elapsedMs, GlobalMenuLinux._stats2str(stats));
                }
                GlobalMenuLinux._processChildren(mi);
            }
        }
        if (eventType == 1) {
            mi.scheduleClearSwing();
            return;
        }
        if (eventType == 2) {
            GlobalMenuLinux._trace("process click event (%s), event source: %s", GlobalMenuLinux._evtype2str(eventType), mi);
            JMenuItem jmi = mi.jitem;
            if (jmi == null) {
                if (TRACE_HIERARCHY_MISMATCHES) {
                    GlobalMenuLinux._trace("can't find corresponding (clicked) ActionMenuItem, event source: " + mi + ", swing menu hierarchy:\n" + this._dumpSwingHierarchy());
                }
                return;
            }
            if (!(jmi instanceof ActionMenuItem)) {
                LOG.error("corresponding (clicked) swing item isn't instance of ActionMenuItem, class=" + jmi.getClass().getName() + ", event source: " + mi);
                return;
            }
            ActionMenuItem ami = (ActionMenuItem)((Object)jmi);
            ApplicationManager.getApplication().invokeLater(() -> ami.doClick());
        }
    }

    public static boolean isAvailable() {
        return ourLib != null;
    }

    public static boolean isPresented() {
        return ourLib != null && ourIsServiceAvailable;
    }

    private static GlobalMenuLib _loadLibrary() {
        if (!SystemInfo.isLinux || ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"linux.native.menu.force.disable") || LoadingState.COMPONENTS_REGISTERED.isOccurred() && !Experiments.getInstance().isFeatureEnabled("linux.native.menu") || !JnaLoader.isLoaded() || GlobalMenuLinux.isUnderVMWithSwiftPluginInstalled()) {
            return null;
        }
        try {
            NativeLibraryLoader.loadPlatformLibrary((String)"dbm");
            return (GlobalMenuLib)Native.load((String)"dbm", GlobalMenuLib.class, Collections.singletonMap("jna.encoding", "UTF8"));
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.info("disable global-menu integration because some of shared libraries isn't installed: " + ule);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean isUnderVMWithSwiftPluginInstalled() {
        if (PluginManagerCore.isPluginInstalled(PluginId.getId((String)"com.intellij.clion-swift"))) {
            try {
                String stdout = StringUtil.toLowerCase((String)ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"lspci"})).getStdout());
                return stdout.contains("vmware") || stdout.contains("virtualbox");
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return false;
    }

    private static Object _getPeerField(@NotNull Component object) {
        try {
            Field field = Component.class.getDeclaredField("peer");
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static long _getX11WindowXid(@NotNull Window frame) {
        try {
            ComponentPeer wndPeer = (ComponentPeer)GlobalMenuLinux._getPeerField(frame);
            if (wndPeer == null) {
                LOG.info("frame peer is null, wait for connection");
                return 0L;
            }
            if (!wndPeer.getClass().getName().equals("sun.awt.X11.XFramePeer")) {
                LOG.info("frame peer isn't instance of XBaseWindow, class of peer: " + wndPeer.getClass());
                return 0L;
            }
            Method method2 = wndPeer.getClass().getMethod("getWindow", new Class[0]);
            if (method2 == null) {
                return 0L;
            }
            return (Long)method2.invoke((Object)wndPeer, new Object[0]);
        }
        catch (Throwable e) {
            LOG.error(e);
            return 0L;
        }
    }

    private String _dumpSwingHierarchy() {
        StringBuilder out = new StringBuilder();
        this._dumpSwingHierarchy(out);
        return out.toString();
    }

    private void _dumpSwingHierarchy(StringBuilder out) {
        for (MenuItemInternal root : this.myRoots) {
            ActionMenu am = (ActionMenu)((Object)root.jitem);
            out.append(am.getText());
            out.append('\n');
            GlobalMenuLinux._dumpActionMenuKids(am, out, 1);
        }
    }

    private static void _dumpActionMenuKids(@NotNull ActionMenu am, StringBuilder out, int indent) {
        for (Component each : am.getPopupMenu().getComponents()) {
            if (each == null || !(each instanceof JMenuItem)) continue;
            for (int c = 0; c < indent; ++c) {
                out.append('\t');
            }
            String txt = ((JMenuItem)each).getText();
            if (txt == null || txt.isEmpty()) {
                txt = "null";
            }
            out.append(txt);
            out.append('\n');
            if (!(each instanceof ActionMenu)) continue;
            GlobalMenuLinux._dumpActionMenuKids((ActionMenu)((Object)each), out, indent + 1);
        }
    }

    private static void _trace(@NonNls String fmt, Object ... args) {
        if (!TRACE_ENABLED) {
            return;
        }
        String msg = String.format(fmt, args);
        GlobalMenuLinux._trace(msg);
    }

    private static void _trace(@NonNls String msg) {
        if (!TRACE_ENABLED) {
            return;
        }
        if (TRACE_SYSOUT) {
            System.out.println(ourDtf.format(new Date()) + ": " + msg);
        } else {
            LOG.info(msg);
        }
    }

    static {
        ourInstances = new ConcurrentHashMap<Long, GlobalMenuLinux>();
        ourIsServiceAvailable = false;
        ourLib = GlobalMenuLinux._loadLibrary();
        if (ourLib == null) {
            ourGLogger = null;
            ourUpdateAllRoots = null;
            ourOnAppmenuServiceAppeared = null;
            ourOnAppmenuServiceVanished = null;
        } else {
            ourGLogger = (level, msg) -> {
                if (level == 5) {
                    if (TRACE_SYSOUT) {
                        GlobalMenuLinux._trace(msg);
                    } else {
                        LOG.info(msg);
                    }
                } else {
                    LOG.error(msg);
                }
            };
            ourUpdateAllRoots = () -> {
                if (!ourIsServiceAvailable) {
                    return;
                }
                for (GlobalMenuLinux gml : ourInstances.values()) {
                    gml._updateRoots();
                }
            };
            ourOnAppmenuServiceAppeared = () -> {
                LOG.info("Appeared dbus-service 'com.canonical.AppMenu.Registrar'");
                ourIsServiceAvailable = true;
                ourUpdateAllRoots.run();
            };
            ourOnAppmenuServiceVanished = () -> {
                LOG.info("Closed dbus-service 'com.canonical.AppMenu.Registrar'");
                ourIsServiceAvailable = false;
                boolean isMainMenuVisible = UISettings.getInstance().getShowMainMenu();
                for (GlobalMenuLinux gml : ourInstances.values()) {
                    gml.myWindowHandle = null;
                    if (!isMainMenuVisible) continue;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        JMenuBar jmenubar = gml.myFrame.getJMenuBar();
                        if (jmenubar != null) {
                            jmenubar.setVisible(true);
                        }
                    });
                }
            };
            try {
                Class<?> platformImpl = Class.forName("com.sun.javafx.application.PlatformImpl");
                Method startup = platformImpl.getMethod("startup", Runnable.class);
                Runnable r = () -> ourLib.startWatchDbus(ourGLogger, ourOnAppmenuServiceAppeared, ourOnAppmenuServiceVanished);
                startup.invoke(null, r);
            }
            catch (Throwable e) {
                LOG.info("can't start main loop via JavaFX (will run it manually): " + e.getMessage());
                Thread glibMain = new Thread(() -> ourLib.runMainLoop(ourGLogger, ourOnAppmenuServiceAppeared, ourOnAppmenuServiceVanished), "GlobalMenuLinux loop");
                glibMain.start();
            }
        }
    }

    private class EventFilter {
        private final ArrayList<QueuedEvent> myQueued = new ArrayList();
        private Timer myTimer;
        private long myClosedMs = 0L;
        private GlobalMenuLib.JRunnable myGlibLoopRunnable;

        private EventFilter() {
        }

        private boolean _isClosed() {
            return this.myClosedMs > 0L;
        }

        private void _stopTimer() {
            if (this.myTimer != null) {
                this.myTimer.stop();
            }
            this.myTimer = null;
        }

        private void _processQueue() {
            for (QueuedEvent q : this.myQueued) {
                GlobalMenuLinux.this._handleEvent(q.uid, q.eventType, false);
            }
            this.myQueued.clear();
        }

        private void _startTimer() {
            this._stopTimer();
            Timer timer2 = new Timer(50, null);
            timer2.addActionListener(e -> {
                if (TRACE_EVENT_FILTER) {
                    GlobalMenuLinux._trace("EventFilter: start execution of timer callback");
                }
                if (this.myTimer != timer2) {
                    if (TRACE_EVENT_FILTER) {
                        GlobalMenuLinux._trace("EventFilter: skip timer-processing because timer was reset (i.e. myTimer == null)");
                    }
                    return;
                }
                this.myGlibLoopRunnable = () -> {
                    int lastRootId = GlobalMenuLinux.this.myRoots.size() - 1;
                    int from = 0;
                    while (from < this.myQueued.size()) {
                        int to;
                        int size = this.myQueued.size();
                        while (from < size && this.myQueued.get((int)from).rootId != 1) {
                            ++from;
                        }
                        if (from == size) break;
                        int first = from - 1;
                        if (first < 0 || this.myQueued.get((int)first).rootId != 0) {
                            while (from < size && this.myQueued.get((int)from).rootId == 1) {
                                ++from;
                            }
                            continue;
                        }
                        while (first >= 1 && this.myQueued.get((int)(first - 1)).rootId == 0 && from - first <= 1) {
                            --first;
                        }
                        for (to = from + 1; to < size && this.myQueued.get((int)to).rootId != lastRootId; ++to) {
                        }
                        if (to == size) break;
                        while (to < size && this.myQueued.get((int)to).rootId == lastRootId) {
                            ++to;
                        }
                        if (TRACE_EVENT_FILTER) {
                            GlobalMenuLinux._trace("EventFilter: remove segment [%d, %d) from queue of size=%d", new Object[]{first, to, this.myQueued.size()});
                        }
                        this.myQueued.subList(first, to).clear();
                        from = first + 1;
                    }
                    if (!this.myQueued.isEmpty()) {
                        if (TRACE_ENABLED) {
                            GlobalMenuLinux._trace("EventFilter: process queued events, size=%d", new Object[]{this.myQueued.size()});
                        }
                        this._processQueue();
                    } else if (TRACE_ENABLED) {
                        GlobalMenuLinux._trace("EventFilter: queue is empty");
                    }
                    this.myTimer = null;
                    this.myClosedMs = 0L;
                    if (TRACE_EVENT_FILTER) {
                        GlobalMenuLinux._trace("EventFilter: filter is opened");
                    }
                };
                ourLib.execOnMainLoop(this.myGlibLoopRunnable);
            });
            this.myTimer = timer2;
            this.myTimer.setRepeats(false);
            this.myTimer.start();
            if (TRACE_EVENT_FILTER) {
                GlobalMenuLinux._trace("EventFilter: start timer");
            }
        }

        boolean check(int uid, int eventType, @NotNull MenuItemInternal mi) {
            boolean isFillEvent = GlobalMenuLinux._isFillEvent(eventType);
            long timeMs = System.currentTimeMillis();
            if (this._isClosed()) {
                if (timeMs - this.myClosedMs > 2000L) {
                    if (TRACE_ENABLED) {
                        GlobalMenuLinux._trace("EventFilter WARNING: close filter by timeout protection");
                    }
                    this._processQueue();
                    this._stopTimer();
                    this.myClosedMs = 0L;
                } else {
                    this.myQueued.add(QueuedEvent.of(uid, eventType, mi.rootPos, timeMs));
                    if (this.myTimer != null) {
                        this.myTimer.restart();
                    }
                    return false;
                }
            }
            if (mi.rootPos != 0) {
                return true;
            }
            if (TRACE_EVENT_FILTER) {
                GlobalMenuLinux._trace("EventFilter: close filter");
            }
            this.myQueued.add(QueuedEvent.of(uid, eventType, mi.rootPos, timeMs));
            this.myClosedMs = timeMs;
            this._startTimer();
            return false;
        }
    }

    private static class QueuedEvent {
        final int uid;
        final int eventType;
        final int rootId;
        final long timeMs;

        private QueuedEvent(int uid, int eventType, int rootId, long timeMs) {
            this.uid = uid;
            this.eventType = eventType;
            this.rootId = rootId;
            this.timeMs = timeMs;
        }

        static QueuedEvent of(int uid, int eventType, int rootId, long timeMs) {
            return new QueuedEvent(uid, eventType, rootId, timeMs);
        }
    }

    private static class MenuItemInternal {
        final int rootPos;
        final int uid;
        final int type;
        final AnAction action;
        final MenuItemInternal parent;
        final List<MenuItemInternal> children = new ArrayList<MenuItemInternal>();
        String txt;
        String originTxt;
        char mnemonic;
        boolean isEnabled = true;
        boolean isChecked = false;
        byte[] iconPngBytes;
        int jmodifiers;
        int jkeycode;
        JMenuItem jitem;
        Pointer nativePeer;
        int position = -1;
        long lastFilledMs = 0L;
        long lastClearedMs = 0L;
        Timer timerClearSwing;

        MenuItemInternal(MenuItemInternal parent, int rootPos, int uid, int type, AnAction action2) {
            this.parent = parent;
            this.rootPos = rootPos;
            this.uid = uid;
            this.type = type;
            this.action = action2;
        }

        int getPosition() {
            return this.position;
        }

        boolean isRoot() {
            return this.rootPos >= 0;
        }

        boolean isToggleable() {
            return this.type == 2 || this.type == 3;
        }

        void clearChildrenSwingRefs() {
            for (MenuItemInternal cmi : this.children) {
                cmi.jitem = null;
                cmi.clearChildrenSwingRefs();
            }
        }

        boolean updateBySwingPeer(@NotNull JMenuItem peer) {
            this.jitem = peer;
            boolean res2 = this.isEnabled != peer.isEnabled();
            this.isEnabled = peer.isEnabled();
            if (this.isToggleable()) {
                if (this.isChecked != peer.isSelected()) {
                    res2 = true;
                }
                this.isChecked = peer.isSelected();
            }
            if (!Objects.equals(this.originTxt, peer.getText())) {
                this.setLabelFromSwingPeer(peer);
                res2 = true;
            }
            this.iconPngBytes = this.isToggleable() ? null : GlobalMenuLinux._icon2png(peer.getIcon());
            KeyStroke ks = peer.getAccelerator();
            if (ks != null) {
                this.jkeycode = ks.getKeyCode();
                this.jmodifiers = ks.getModifiers();
            }
            return res2;
        }

        void setLabelFromSwingPeer(@NotNull JMenuItem peer) {
            this.originTxt = peer.getText();
            this.txt = this.originTxt != null ? this.originTxt : "";
            this.mnemonic = '\u0000';
            if (this.originTxt != null && !this.originTxt.isEmpty()) {
                int mnemonicCode = peer.getMnemonic();
                int mnemonicIndex = peer.getDisplayedMnemonicIndex();
                if (mnemonicIndex >= 0 && mnemonicIndex < this.originTxt.length() && Character.toUpperCase(this.originTxt.charAt(mnemonicIndex)) == mnemonicCode) {
                    StringBuilder res2 = new StringBuilder(this.originTxt);
                    res2.insert(mnemonicIndex, '_');
                    this.txt = res2.toString();
                    this.mnemonic = (char)mnemonicCode;
                }
            }
        }

        void updateNative() {
            if (this.nativePeer == null) {
                return;
            }
            ourLib.setItemLabel(this.nativePeer, this.txt);
            ourLib.setItemEnabled(this.nativePeer, this.isEnabled);
            ourLib.setItemIcon(this.nativePeer, this.iconPngBytes, this.iconPngBytes != null ? this.iconPngBytes.length : 0);
            if (this.isToggleable()) {
                ourLib.toggleItemStateChecked(this.nativePeer, this.isChecked);
            }
            if (this.jkeycode != 0) {
                int x11keycode = X11KeyCodes.jkeycode2X11code(this.jkeycode, 0);
                if (x11keycode != 0) {
                    ourLib.setItemShortcut(this.nativePeer, this.jmodifiers, x11keycode);
                } else if (TRACE_ENABLED) {
                    GlobalMenuLinux._trace("unknown x11 keycode for jcode=" + this.jkeycode);
                }
            }
        }

        MenuItemInternal findCorrespondingChild(@NotNull Component target2) {
            if (this.children.isEmpty()) {
                return null;
            }
            if (target2 instanceof JSeparator) {
                for (MenuItemInternal child2 : this.children) {
                    if (child2.position != -1 || child2.action != null) continue;
                    return child2;
                }
                return null;
            }
            if (!(target2 instanceof JMenuItem)) {
                return null;
            }
            JMenuItem jmi = (JMenuItem)target2;
            String label2 = jmi.getText();
            if (label2 != null && !label2.isEmpty()) {
                for (MenuItemInternal child3 : this.children) {
                    if (!label2.equals(child3.originTxt)) continue;
                    return child3;
                }
            }
            AnAction act = null;
            if (target2 instanceof ActionMenuItem) {
                act = ((ActionMenuItem)((Object)target2)).getAnAction();
            }
            if (target2 instanceof ActionMenu) {
                act = ((ActionMenu)((Object)target2)).getAnAction();
            }
            if (act == null) {
                return null;
            }
            for (MenuItemInternal child4 : this.children) {
                if (!act.equals(child4.action)) continue;
                return child4;
            }
            return null;
        }

        String printHierarchy() {
            StringBuilder res2 = new StringBuilder();
            this.printHierarchy(res2, 0);
            return res2.toString();
        }

        void printHierarchy(StringBuilder out, int indent) {
            for (MenuItemInternal kid : this.children) {
                if (out.length() > 0) {
                    out.append('\n');
                }
                for (int c = 0; c < indent; ++c) {
                    out.append('\t');
                }
                out.append(kid.toString());
                kid.printHierarchy(out, indent + 1);
            }
        }

        public String toString() {
            String res2 = String.format("'%s' (uid=%d, act=%s)", this.txt, this.uid, this.action);
            if (this.position == -1) {
                res2 = res2 + " [toDelele]";
            }
            return res2;
        }

        String toStringShort() {
            String res2 = String.format("'%s'", this.txt);
            if (this.position == -1) {
                res2 = res2 + " [D]";
            }
            res2 = this.isRoot() ? "Root " + res2 : "Submenu " + res2;
            return res2;
        }

        void scheduleClearSwing() {
            if (this.timerClearSwing != null) {
                this.timerClearSwing.restart();
                if (TRACE_CLEARING) {
                    GlobalMenuLinux._trace("\t reset clear timer of item '%s'", new Object[]{this.toStringShort()});
                }
                return;
            }
            this.timerClearSwing = new Timer(2000, e -> this._clearSwing());
            this.timerClearSwing.setRepeats(false);
            this.timerClearSwing.start();
            if (TRACE_CLEARING) {
                GlobalMenuLinux._trace("\t scheduled (300 ms later) to clear '%s'", new Object[]{this.toStringShort()});
            }
        }

        void cancelClearSwing() {
            if (this.timerClearSwing != null) {
                this.timerClearSwing.stop();
                this.timerClearSwing = null;
            }
            MenuItemInternal p = this.parent;
            while (p != null) {
                p.cancelClearSwing();
                p = p.parent;
            }
        }

        private void _clearSwing() {
            if (this.timerClearSwing == null) {
                return;
            }
            if (this.jitem == null) {
                if (TRACE_CLEARING) {
                    GlobalMenuLinux._trace("corresponding (closing) swing item is null - nothing to clear, event source: ", new Object[]{this});
                }
                return;
            }
            if (!(this.jitem instanceof ActionMenu)) {
                LOG.error("corresponding (closing) swing item isn't instance of ActionMenu, class=" + this.jitem.getClass().getName() + ", event source: " + this.toString());
                return;
            }
            ActionMenu am = (ActionMenu)((Object)this.jitem);
            am.clearItems();
            this.clearChildrenSwingRefs();
            this._onSwingCleared(System.currentTimeMillis());
            if (TRACE_CLEARING) {
                GlobalMenuLinux._trace("\t cleared '%s'", new Object[]{this.toStringShort()});
            }
        }

        private void _onSwingCleared(long timeMs) {
            this.lastClearedMs = timeMs;
            if (this.timerClearSwing != null) {
                this.timerClearSwing.stop();
                this.timerClearSwing = null;
            }
            for (MenuItemInternal kid : this.children) {
                kid._onSwingCleared(timeMs);
            }
        }
    }

    static final class MyActionTuner
    implements ActionConfigurationCustomizer {
        MyActionTuner() {
        }

        @Override
        public void customize(@NotNull ActionManager actionManager) {
            if (!SystemInfo.isLinux || ApplicationManager.getApplication().isUnitTestMode() || !GlobalMenuLinux.isPresented()) {
                return;
            }
            actionManager.registerAction(GlobalMenuLinux.TOGGLE_SWING_MENU_ACTION_ID, new AnAction(GlobalMenuLinux.TOGGLE_SWING_MENU_ACTION_NAME, GlobalMenuLinux.TOGGLE_SWING_MENU_ACTION_DESC, null){
                boolean enabled;
                {
                    super(x0, x1, x2);
                    this.enabled = false;
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    for (GlobalMenuLinux gml : ourInstances.values()) {
                        gml.toggle(this.enabled);
                    }
                    this.enabled = !this.enabled;
                }
            });
        }
    }
}

