/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.core.CoreBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    static final PersistentFS ourPersistence = PersistentFS.getInstance();
    static final int IS_WRITABLE_FLAG = 0x1000000;
    static final int IS_HIDDEN_FLAG = 0x2000000;
    private static final int INDEXED_FLAG = 0x4000000;
    static final int CHILDREN_CACHED = 0x8000000;
    static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
    private static final int DIRTY_FLAG = 0x10000000;
    static final int IS_SYMLINK_FLAG = 0x20000000;
    private static final int HAS_SYMLINK_FLAG = 0x40000000;
    static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;
    static final int ALL_FLAGS_MASK = -16777216;
    @NotNull
    final VfsData.Segment mySegment;
    private final VirtualDirectoryImpl myParent;
    final int myId;
    private volatile CachedFileType myFileType;
    static final VirtualFileSystemEntry NULL_VIRTUAL_FILE = new VirtualFileSystemEntry(){

        @Override
        public String toString() {
            return "NULL";
        }

        @NotNull
        public NewVirtualFileSystem getFileSystem() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChild(@NotNull String name) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile refreshAndFindChild(@NotNull String name) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChildIfCached(@NotNull String name) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<VirtualFile> getCachedChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Iterable<VirtualFile> iterInDbChildren() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public VirtualFile[] getChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() {
            throw new UnsupportedOperationException();
        }
    };

    VirtualFileSystemEntry(int id2, @NotNull VfsData.Segment segment, @Nullable VirtualDirectoryImpl parent) {
        this.mySegment = segment;
        this.myId = id2;
        this.myParent = parent;
        if (id2 <= 0) {
            throw new IllegalArgumentException("id must be positive but got: " + id2);
        }
    }

    private VirtualFileSystemEntry() {
        this.mySegment = null;
        this.myParent = null;
        this.myId = -42;
    }

    void registerLink(@NotNull VirtualFileSystem fs) {
        if (fs instanceof LocalFileSystemImpl && this.is(VFileProperty.SYMLINK) && this.isValid()) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(this.myId, (VirtualFile)this.myParent, this.getPath(), this.getCanonicalPath());
        }
    }

    void updateLinkStatus() {
        this.setFlagInt(0x40000000, this.is(VFileProperty.SYMLINK) || this.getParent().getFlagInt(0x40000000));
        this.registerLink((VirtualFileSystem)this.getFileSystem());
    }

    @NotNull
    public String getName() {
        return this.getNameSequence().toString();
    }

    @NotNull
    public CharSequence getNameSequence() {
        return FileNameCache.getVFileName(this.getNameId());
    }

    public final int getNameId() {
        return this.mySegment.getNameId(this.myId);
    }

    public VirtualDirectoryImpl getParent() {
        VirtualDirectoryImpl changedParent = this.mySegment.getChangedParent(this.myId);
        return changedParent != null ? changedParent : this.myParent;
    }

    public boolean hasSymlink() {
        return this.getFlagInt(0x40000000);
    }

    public boolean isDirty() {
        return this.getFlagInt(0x10000000);
    }

    public long getModificationStamp() {
        return this.isValid() ? this.mySegment.getModificationStamp(this.myId) : -1L;
    }

    public void setModificationStamp(long modificationStamp) {
        this.mySegment.setModificationStamp(this.myId, modificationStamp);
    }

    boolean getFlagInt(int mask) {
        return this.mySegment.getFlag(this.myId, mask);
    }

    void setFlagInt(int mask, boolean value2) {
        this.mySegment.setFlag(this.myId, mask, value2);
    }

    public boolean isFileIndexed() {
        return this.getFlagInt(0x4000000);
    }

    public void setFileIndexed(boolean indexed) {
        this.setFlagInt(0x4000000, indexed);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file2 : this.getCachedChildren()) {
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
    }

    protected char @NotNull [] appendPathOnFileSystem(int accumulatedPathLength, int[] positionRef) {
        CharSequence name = this.getNameSequence();
        char[] chars = this.getParent().appendPathOnFileSystem(accumulatedPathLength + 1 + name.length(), positionRef);
        int i2 = positionRef[0];
        chars[i2] = 47;
        positionRef[0] = VirtualFileSystemEntry.copyString(chars, i2 + 1, name);
        return chars;
    }

    private static int copyString(char @NotNull [] chars, int pos, @NotNull CharSequence s) {
        int length = s.length();
        CharArrayUtil.getChars((CharSequence)s, (char[])chars, (int)0, (int)pos, (int)length);
        return pos + length;
    }

    @NotNull
    public String getUrl() {
        String protocol = this.getFileSystem().getProtocol();
        int prefixLen = protocol.length() + "://".length();
        char[] chars = this.appendPathOnFileSystem(prefixLen, new int[]{prefixLen});
        VirtualFileSystemEntry.copyString(chars, VirtualFileSystemEntry.copyString(chars, 0, protocol), "://");
        return StringFactory.createShared((char[])chars);
    }

    @NotNull
    public String getPath() {
        return StringFactory.createShared((char[])this.appendPathOnFileSystem(0, new int[]{0}));
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ourPersistence.deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName)) {
            return;
        }
        this.validateName(newName);
        ourPersistence.renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        this.validateName(name);
        return ourPersistence.createChildFile(requestor, (VirtualFile)this, name);
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        ourPersistence.setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return ourPersistence.getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        ourPersistence.setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return ourPersistence.getLength((VirtualFile)this);
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(CoreBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> ourPersistence.copyFile(requestor, (VirtualFile)this, newParent, copyName));
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> {
            ourPersistence.moveFile(requestor, (VirtualFile)this, newParent);
            return this;
        });
    }

    public int getId() {
        return this.myId;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof VirtualFileSystemEntry && this.myId == ((VirtualFileSystemEntry)((Object)o)).myId;
    }

    public int hashCode() {
        return this.myId;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        this.validateName(name);
        return ourPersistence.createChildDirectory(requestor, (VirtualFile)this, name);
    }

    private void validateName(@NotNull String name) throws IOException {
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name}));
        }
    }

    public boolean exists() {
        return this.mySegment.vfsData.isFileValid(this.myId);
    }

    public boolean isValid() {
        return this.exists();
    }

    public String toString() {
        return this.getUrl();
    }

    public void setNewName(@NotNull String newName) {
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IllegalArgumentException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        this.mySegment.setNameId(this.myId, FileNameCache.storeName(newName));
        parent.addChild(this);
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public void setParent(@NotNull VirtualFile newParent) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild((VirtualFile)this);
        VirtualDirectoryImpl directory = (VirtualDirectoryImpl)newParent;
        this.mySegment.changeParent(this.myId, directory);
        directory.addChild(this);
        this.updateLinkStatus();
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    public void invalidate() {
        this.mySegment.vfsData.invalidateFile(this.myId);
    }

    @NotNull
    public Charset getCharset() {
        return this.isCharsetSet() ? super.getCharset() : this.computeCharset();
    }

    @NotNull
    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else {
            FileType fileType = this.getFileType();
            if (this.isCharsetSet()) {
                return super.getCharset();
            }
            try {
                byte[] content2 = VfsUtilCore.loadBytes((VirtualFile)this);
                charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, content2, fileType);
            }
            catch (IOException e) {
                return super.getCharset();
            }
        }
        return charset;
    }

    public String getPresentableName() {
        if (UISettings.getInstance().getHideKnownExtensionInTabs() && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            return nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
        }
        return this.getName();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == VFileProperty.SPECIAL) {
            return this.getFlagInt(Integer.MIN_VALUE);
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.getFlagInt(0x20000000);
        }
        return super.is(property);
    }

    public void updateProperty(@NotNull String property, boolean value2) {
        if (property == "writable") {
            this.setFlagInt(0x1000000, value2);
        }
        if (property == "HIDDEN") {
            this.setFlagInt(0x2000000, value2);
        }
    }

    public String getCanonicalPath() {
        if (this.getFlagInt(0x40000000)) {
            if (this.is(VFileProperty.SYMLINK)) {
                return ourPersistence.resolveSymLink((VirtualFile)this);
            }
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.getFlagInt(0x40000000)) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }

    public boolean isRecursiveOrCircularSymlink() {
        if (!this.is(VFileProperty.SYMLINK)) {
            return false;
        }
        NewVirtualFile resolved = this.getCanonicalFile();
        if (resolved == null) {
            return false;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)resolved, (VirtualFile)this, (boolean)false)) {
            return true;
        }
        for (VirtualDirectoryImpl p = this.getParent(); p != null; p = p.getParent()) {
            NewVirtualFile parentResolved;
            if (!p.getFlagInt(0x40000000)) {
                return false;
            }
            if (!p.is(VFileProperty.SYMLINK) || !resolved.equals(parentResolved = p.getCanonicalFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public FileType getFileType() {
        FileType type;
        CachedFileType cache = this.myFileType;
        FileType fileType = type = cache == null ? null : cache.getUpToDateOrNull();
        if (type == null) {
            type = super.getFileType();
            this.myFileType = CachedFileType.forType(type);
        }
        return type;
    }
}

