/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null && System.getProperty("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = Collections.synchronizedSet(CollectionFactory.createFilePathSet());
    private static boolean insideGettingRoots;

    static void assertAccessInTests(@NotNull VirtualFileSystemEntry child2, @NotNull NewVirtualFileSystem delegate) {
        Application application = ApplicationManager.getApplication();
        if (SHOULD_PERFORM_ACCESS_CHECK && application.isUnitTestMode() && application instanceof ApplicationImpl && ((ApplicationImpl)application).getComponentCreated() && !ApplicationInfoImpl.isInStressTest()) {
            boolean isUnder;
            if (delegate != LocalFileSystem.getInstance() && delegate != JarFileSystem.getInstance()) {
                return;
            }
            if (child2.getParent() == null || child2.getParent().getParent() == null) {
                return;
            }
            Set<String> allowed = VfsRootAccess.allowedRoots();
            boolean bl = isUnder = allowed == null || allowed.isEmpty();
            if (!isUnder) {
                String childPath = child2.getPath();
                if (delegate == JarFileSystem.getInstance()) {
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar((VirtualFile)child2);
                    assert (local != null) : child2;
                    childPath = local.getPath();
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (FileUtil.startsWith((String)childPath, (String)root)) {
                        isUnder = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder = FileUtil.startsWith((String)childPath, (String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root)))))) continue;
                    break;
                }
            }
            assert (isUnder) : "File accessed outside allowed roots: " + (Object)((Object)child2) + ";\nAllowed roots: " + new ArrayList<String>(allowed);
        }
    }

    @Nullable
    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        Set allowed = CollectionFactory.createFilePathSet();
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        String homePath2 = PathManager.getHomePathFor(Application.class);
        if (homePath2 != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output));
            }
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            // empty catch block
        }
        try {
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.getJavaHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
            allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
            allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".m2")));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".gradle")));
            allowed.add("/etc");
            allowed.add("/private/etc");
            for (Project project : openProjects) {
                if (!project.isInitialized()) {
                    return null;
                }
                for (String url : ProjectRootManager.getInstance((Project)project).getContentRootUrls()) {
                    allowed.add(VfsUtilCore.urlToPath((String)url));
                }
                for (String url : VfsRootAccess.getAllRootUrls(project)) {
                    allowed.add(StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)url), (String)"!/"));
                }
                String location = project.getBasePath();
                assert (location != null) : project;
                allowed.add(FileUtil.toSystemIndependentName((String)location));
            }
        }
        catch (Error error) {
            // empty catch block
        }
        allowed.addAll(ourAdditionalRoots);
        return allowed;
    }

    private static String getJavaHome() {
        String javaHomeParent;
        String javaHome = SystemProperties.getJavaHome();
        if (JdkUtil.checkForJre((String)javaHome) && !JdkUtil.checkForJdk((String)javaHome) && JdkUtil.checkForJre((String)(javaHomeParent = PathUtil.getParentPath((String)javaHome))) && JdkUtil.checkForJdk((String)javaHomeParent)) {
            javaHome = javaHomeParent;
        }
        return javaHome;
    }

    private static String findInUserHome(String path) {
        File file2 = new File(SystemProperties.getUserHome(), path);
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e) {
            return file2.getPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getAllRootUrls(Project project) {
        insideGettingRoots = true;
        try {
            ObjectOpenHashSet roots = new ObjectOpenHashSet();
            OrderEnumerator enumerator = ProjectRootManager.getInstance((Project)project).orderEntries().using((RootModelProvider)new DefaultModulesProvider(project));
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator.classes().getUrls());
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator.sources().getUrls());
            ObjectOpenHashSet objectOpenHashSet = roots;
            return objectOpenHashSet;
        }
        finally {
            insideGettingRoots = false;
        }
    }

    public static void allowRootAccess(@NotNull Disposable disposable2, String ... roots) {
        if (roots.length == 0) {
            return;
        }
        VfsRootAccess.allowRootAccess(roots);
        Disposer.register((Disposable)disposable2, () -> VfsRootAccess.disallowRootAccess(roots));
    }

    @Deprecated
    public static void allowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.add(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
        }
    }

    @Deprecated
    public static void disallowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.remove(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
        }
    }
}

