/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class FsRoot
extends VirtualDirectoryImpl {
    private final String myPathWithOneSlash;

    public FsRoot(int id2, int nameId, @NotNull VfsData vfsData, @NotNull NewVirtualFileSystem fs, @NotNull String pathBeforeSlash) throws VfsData.FileAlreadyCreatedException {
        super(id2, vfsData.getSegment(id2, true), new VfsData.DirectoryData(), null, fs);
        if (!FsRoot.looksCanonical(pathBeforeSlash)) {
            throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'");
        }
        this.myPathWithOneSlash = pathBeforeSlash + '/';
        VfsData.initFile(id2, this.mySegment, nameId, this.myData);
    }

    @Override
    protected char @NotNull [] appendPathOnFileSystem(int pathLength, int[] position) {
        int myLength = this.myPathWithOneSlash.length() - 1;
        char[] chars = new char[pathLength + myLength];
        CharArrayUtil.getChars((CharSequence)this.myPathWithOneSlash, (char[])chars, (int)0, (int)position[0], (int)myLength);
        position[0] = position[0] + myLength;
        return chars;
    }

    @Override
    public void setNewName(@NotNull String newName) {
        throw new IncorrectOperationException();
    }

    @Override
    public final void setParent(@NotNull VirtualFile newParent) {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public String getPath() {
        return this.myPathWithOneSlash;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.getFileSystem().getProtocol() + "://" + this.getPath();
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i2;
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start2 = 0;
        while ((i2 = pathBeforeSlash.indexOf("..", start2)) != -1) {
            if (!(i2 != 0 && pathBeforeSlash.charAt(i2 - 1) != '/' || i2 != pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i2 + 2) != '/')) {
                return false;
            }
            start2 = i2 + 1;
        }
        return true;
    }
}

