/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.EDT;
import gnu.trove.TLongObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RefreshQueueImpl.class);
    private final Executor myQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RefreshQueue Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final Executor myEventProcessingQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Async Refresh Event Processing", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(IdeBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
    private int myBusyThreads;
    private final TLongObjectHashMap<RefreshSession> mySessions = new TLongObjectHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);

    public void execute(@NotNull RefreshSessionImpl session2) {
        if (session2.isAsynchronous()) {
            this.queueSession(session2, session2.getModality());
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isWriteThread()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                this.doScan(session2);
                session2.fireEvents(session2.getEvents(), null);
            } else {
                if (((ApplicationEx)app).holdsReadLock() || EDT.isCurrentThreadEdt()) {
                    LOG.error("Do not perform a synchronous refresh under read lock (except from EDT) - causes deadlocks if there are events to fire.");
                    return;
                }
                this.queueSession(session2, ModalityState.defaultModalityState());
                session2.waitFor();
            }
        }
    }

    private void queueSession(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        this.myQueue.execute(() -> {
            this.startRefreshActivity();
            try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Doing file refresh. " + (Object)((Object)session2), HeavyProcessLatch.Type.Syncing);){
                this.doScan(session2);
            }
            finally {
                this.finishRefreshActivity();
                if (Registry.is((String)"vfs.async.event.processing")) {
                    this.scheduleAsynchronousPreprocessing(session2, modality);
                } else {
                    AppUIExecutor.onWriteThread((ModalityState)modality).later().submit(() -> session2.fireEvents(session2.getEvents(), null));
                }
            }
        });
        this.myEventCounter.eventHappened((Object)session2);
    }

    private void scheduleAsynchronousPreprocessing(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        try {
            this.startRefreshActivity();
            ReadAction.nonBlocking(() -> RefreshQueueImpl.runAsyncListeners(session2)).wrapProgress(this.myRefreshIndicator).finishOnUiThread(modality, Runnable::run).submit(this.myEventProcessingQueue).onProcessed(__ -> this.finishRefreshActivity()).onError(t -> {
                if (!this.myRefreshIndicator.isCanceled()) {
                    LOG.error(t);
                }
            });
        }
        catch (AlreadyDisposedException | RejectedExecutionException e) {
            LOG.debug(e);
        }
    }

    private synchronized void startRefreshActivity() {
        if (this.myBusyThreads++ == 0) {
            this.myRefreshIndicator.start();
        }
    }

    private synchronized void finishRefreshActivity() {
        if (--this.myBusyThreads == 0) {
            this.myRefreshIndicator.stop();
        }
    }

    @NotNull
    private static Runnable runAsyncListeners(@NotNull RefreshSessionImpl session2) {
        List events = ContainerUtil.filter(session2.getEvents(), e -> {
            VirtualFile file2 = e instanceof VFileCreateEvent ? ((VFileCreateEvent)e).getParent() : e.getFile();
            return file2 == null || file2.isValid();
        });
        List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
        return () -> session2.fireEvents(events, appliers);
    }

    private void doScan(@NotNull RefreshSessionImpl session2) {
        try {
            this.updateSessionMap(session2, true);
            session2.scan();
        }
        finally {
            this.updateSessionMap(session2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(@NotNull RefreshSession session2, boolean add2) {
        long id2 = session2.getId();
        if (id2 != 0L) {
            TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
            synchronized (tLongObjectHashMap) {
                if (add2) {
                    this.mySessions.put(id2, (Object)session2);
                } else {
                    this.mySessions.remove(id2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSession(long id2) {
        RefreshSession session2;
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            session2 = (RefreshSession)this.mySessions.get(id2);
        }
        if (session2 instanceof RefreshSessionImpl) {
            ((RefreshSessionImpl)session2).cancel();
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state) {
        return new RefreshSessionImpl(async, recursively, finishRunnable, state);
    }

    public void processSingleEvent(@NotNull VFileEvent event) {
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = refreshQueue.mySessions;
        synchronized (tLongObjectHashMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            this.mySessions.forEachValue(session2 -> {
                ((RefreshSessionImpl)((Object)session2)).cancel();
                return true;
            });
        }
    }
}

