/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ChildInfoImpl
implements ChildInfo {
    public static final int UNKNOWN_ID_YET = -238;
    private final int id;
    private final int nameId;
    private final String symLinkTarget;
    private final ChildInfo @Nullable(value="null means children are unknown") [] children;
    private final byte fileAttributesType;
    @FileAttributes.Flags
    private final byte flags;
    private final long length;
    private final long lastModified;

    public ChildInfoImpl(int id2, @NotNull String name, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        this(id2, FileNameCache.storeName(name), attributes, children2, symLinkTarget);
    }

    public ChildInfoImpl(int id2, int nameId, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        this.nameId = nameId;
        this.id = id2;
        this.children = children2;
        this.symLinkTarget = symLinkTarget;
        if (id2 <= 0 && id2 != -238 || nameId <= 0 && nameId != -238) {
            throw new IllegalArgumentException("invalid arguments id: " + id2 + "; nameId: " + nameId);
        }
        if (attributes == null) {
            this.fileAttributesType = (byte)-1;
            this.flags = (byte)-1;
            this.length = 0L;
            this.lastModified = 0L;
        } else {
            this.fileAttributesType = (byte)(attributes.type == null ? -1 : (byte)attributes.type.ordinal());
            this.flags = attributes.flags;
            this.length = attributes.length;
            this.lastModified = attributes.lastModified;
        }
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public CharSequence getName() {
        return FileNameCache.getVFileName(this.nameId);
    }

    public int getNameId() {
        return this.nameId;
    }

    public String getSymlinkTarget() {
        return this.symLinkTarget;
    }

    public ChildInfo @Nullable [] getChildren() {
        return this.children;
    }

    public FileAttributes getFileAttributes() {
        return this.flags == -1 ? null : FileAttributes.createFrom((byte)this.fileAttributesType, (byte)this.flags, (long)this.length, (long)this.lastModified);
    }

    public String toString() {
        return (this.nameId > 0 ? this.getName() : "?") + "; nameId: " + this.nameId + "; id: " + this.id + " (" + this.getFileAttributes() + ")" + (this.children == null ? "" : "\n  " + StringUtil.join((Object[])this.children, info -> info.toString().replaceAll("\n", "\n  "), (String)"\n  "));
    }
}

