/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFileImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Urls;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class HttpFileSystemBase
extends HttpFileSystem {
    private final String myProtocol;

    public HttpFileSystemBase(String protocol) {
        this.myProtocol = protocol;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return this.findFileByPath(path, false);
    }

    public VirtualFile findFileByPath(@NotNull String path, boolean isDirectory) {
        return HttpFileSystemBase.getRemoteFileManager().getOrCreateFile(null, Urls.newFromIdea((CharSequence)VirtualFileManager.constructUrl((String)this.myProtocol, (String)path)), path, isDirectory);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2) {
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2, parentDisposable);
    }

    public void removeFileListener(@NotNull HttpVirtualFileListener listener2) {
        HttpFileSystemBase.getRemoteFileManager().removeFileListener(listener2);
    }

    public boolean isFileDownloaded(@NotNull VirtualFile file2) {
        return file2 instanceof HttpVirtualFile && ((HttpVirtualFile)file2).getFileInfo().getState() == RemoteFileState.DOWNLOADED;
    }

    @NotNull
    public VirtualFile createChild(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) {
        String parentPath = parent.getPath();
        boolean hasEndSlash = parentPath.charAt(parentPath.length() - 1) == '/';
        return HttpFileSystemBase.getRemoteFileManager().getOrCreateFile((HttpVirtualFileImpl)parent, Urls.newFromIdea((CharSequence)(parent.getUrl() + (hasEndSlash ? "" : Character.valueOf('/')) + name)), parentPath + (hasEndSlash ? "" : Character.valueOf('/')) + name, isDirectory);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        return this.createChild(vDir, dirName, true);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        return this.createChild(vDir, fileName, false);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        return VirtualFileManager.constructUrl((String)this.myProtocol, (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String getProtocol() {
        return this.myProtocol;
    }

    private static RemoteFileManagerImpl getRemoteFileManager() {
        return (RemoteFileManagerImpl)RemoteFileManager.getInstance();
    }
}

