/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.FilePartNodeRoot;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePartNode {
    private static final FilePartNode[] EMPTY_ARRAY = new FilePartNode[0];
    static final int JAR_SEPARATOR_NAME_ID = -2;
    private final int nameId;
    FilePartNode @NotNull [] children = EMPTY_ARRAY;
    private Object leaves;
    @NotNull
    volatile Object myFileOrUrl;
    final NewVirtualFileSystem myFS;

    FilePartNode(int nameId, @NotNull Object fileOrUrl, @NotNull NewVirtualFileSystem fs) {
        this.myFS = fs;
        assert (nameId > 0 || nameId == -2) : nameId + "; " + this.getClass();
        this.nameId = nameId;
        this.myFileOrUrl = fileOrUrl;
        if (fileOrUrl instanceof VirtualFile) {
            assert (this.myFile().getFileSystem() == this.myFS) : "myFs=" + this.myFS + "; myFile().getFileSystem()=" + this.myFile().getFileSystem() + "; " + fileOrUrl;
            if (this.myFile().getParent() == null && fs instanceof ArchiveFileSystem) assert (nameId == -2) : nameId;
        }
    }

    private VirtualFile myFile() {
        return FilePartNode.myFile(this.myFileOrUrl);
    }

    void addLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves = this.leaves;
        Object[] newLeaves = leaves == null ? pointer : (leaves instanceof VirtualFilePointerImpl ? new VirtualFilePointerImpl[]{(VirtualFilePointerImpl)((Object)leaves), pointer} : ArrayUtil.append((Object[])((VirtualFilePointerImpl[])leaves), (Object)pointer));
        this.associate(newLeaves);
    }

    int removeLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves = this.leaves;
        if (leaves == null) {
            return 0;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            if (leaves == pointer) {
                this.leaves = null;
                return 0;
            }
            return 1;
        }
        VirtualFilePointerImpl[] newLeaves = (VirtualFilePointerImpl[])ArrayUtil.remove((Object[])((VirtualFilePointerImpl[])leaves), (Object)((Object)pointer));
        if (newLeaves.length == 0) {
            newLeaves = null;
        }
        this.leaves = newLeaves;
        return newLeaves == null ? 0 : newLeaves.length;
    }

    static VirtualFile myFile(@NotNull Object fileOrUrl) {
        return fileOrUrl instanceof VirtualFile ? (VirtualFile)fileOrUrl : null;
    }

    @NotNull
    private String myUrl() {
        return FilePartNode.myUrl(this.myFileOrUrl);
    }

    @NotNull
    static String myUrl(Object fileOrUrl) {
        return fileOrUrl instanceof VirtualFile ? ((VirtualFile)fileOrUrl).getUrl() : (String)fileOrUrl;
    }

    FilePartNode(@NotNull NewVirtualFileSystem fs) {
        this.nameId = -1;
        this.myFileOrUrl = "";
        this.myFS = fs;
    }

    @NotNull
    static CharSequence fromNameId(int nameId) {
        return nameId == -2 ? "!/" : FileNameCache.getVFileName(nameId);
    }

    @NotNull
    CharSequence getName() {
        return FilePartNode.fromNameId(this.nameId);
    }

    public String toString() {
        return this.getName() + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    static int getNameId(@NotNull VirtualFile file2) {
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return -2;
        }
        return ((VirtualFileSystemEntry)file2).getNameId();
    }

    @Contract(value="_, _, true, _ -> !null")
    FilePartNode findChildByNameId(@Nullable VirtualFile file2, int nameId, boolean createIfNotFound, @NotNull NewVirtualFileSystem childFs) {
        if (nameId <= 0 && nameId != -2) {
            throw new IllegalArgumentException("invalid argument nameId: " + nameId);
        }
        for (FilePartNode child2 : this.children) {
            if (!child2.nameEqualTo(nameId)) continue;
            return child2;
        }
        if (createIfNotFound) {
            int index;
            CharSequence name = FilePartNode.fromNameId(nameId);
            int n = index = this.children.length == 0 ? -1 : this.binarySearchChildByName(name);
            if (!$assertionsDisabled && index >= 0) {
                FilePartNode child3 = this.children[index];
                throw new AssertionError((Object)(index + " : child= '" + child3 + "'; child.nameEqualTo(nameId)=" + child3.nameEqualTo(nameId) + "; child.getClass()=" + child3.getClass() + "; child.nameId=" + child3.nameId + "; child.getName()='" + child3.getName() + "'; nameId=" + nameId + "; name='" + name + "'; compare(child) = " + StringUtil.compare((CharSequence)child3.getName(), (CharSequence)name, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) + "; UrlPart.nameEquals: " + FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals((Object)child3.getName(), (Object)FilePartNode.fromNameId(nameId)) + "; name.equals(child.getName())=" + child3.getName().equals(name)));
            }
            Object fileOrUrl = file2;
            if (fileOrUrl == null) {
                fileOrUrl = this.nameId == -1 ? name.toString() : FilePartNode.childUrl(this.myUrl(), name, childFs);
            }
            FilePartNode child4 = new FilePartNode(nameId, fileOrUrl, childFs);
            this.children = (FilePartNode[])ArrayUtil.insert((Object[])this.children, (int)(-index - 1), (Object)child4);
            return child4;
        }
        return null;
    }

    boolean nameEqualTo(int nameId) {
        return this.nameId == nameId;
    }

    int binarySearchChildByName(@NotNull CharSequence name) {
        return ObjectUtils.binarySearch((int)0, (int)this.children.length, i2 -> {
            FilePartNode child2 = this.children[i2];
            CharSequence childName = child2.getName();
            return StringUtil.compare((CharSequence)childName, (CharSequence)name, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
        });
    }

    void addRecursiveDirectoryPtrTo(@NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        this.processPointers(pointer -> {
            if (pointer.isRecursive()) {
                toFirePointers.putValue((Object)pointer.myListener, (Object)pointer);
            }
        });
    }

    void doCheckConsistency(@Nullable VirtualFile parent, @NotNull String name, @NotNull String urlFromRoot) {
        VirtualFile myFile = this.myFile();
        if (!(this instanceof FilePartNodeRoot)) {
            if (myFile == null) {
                String myUrl = this.myUrl();
                String expectedUrl = StringUtil.trimEnd((String)urlFromRoot, (char)'/');
                String actualUrl = StringUtil.trimEnd((String)myUrl, (char)'/');
                assert (FileUtil.namesEqual((String)actualUrl, (String)expectedUrl)) : "Expected url: '" + expectedUrl + "' but got: '" + actualUrl + "'";
            } else assert (Comparing.equal((Object)FilePartNode.getParentThroughJar(myFile, this.myFS), (Object)parent)) : "parent: " + parent + "; myFile: " + myFile;
        }
        assert (!"..".equals(name) && !".".equals(name)) : "url must not contain '.' or '..' but got: " + this;
        String prevChildName = "";
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            String childUrlFromRoot;
            FilePartNode child2 = this.children[i2];
            assert (this instanceof FilePartNodeRoot || myFile != null || child2.myFile() == null) : "this: " + this + "; myFileOrUrl: " + this.myFileOrUrl + "; child: " + child2 + "; child.myFile: " + child2.myFile() + "; parent: " + parent + "; urlFromRoot: " + urlFromRoot;
            String childName = child2.getName().toString();
            boolean needSeparator = !urlFromRoot.isEmpty() && !urlFromRoot.endsWith("/") && !childName.equals("!/");
            String string = childUrlFromRoot = needSeparator ? urlFromRoot + "/" + childName : urlFromRoot + childName;
            if (child2.myFS != this.myFS) {
                childUrlFromRoot = child2.myFS.getProtocol() + StringUtil.trimStart((String)childUrlFromRoot, (String)this.myFS.getProtocol());
            }
            child2.doCheckConsistency(myFile, childName, childUrlFromRoot);
            if (i2 != 0) assert (!FileUtil.namesEqual((String)childName, (String)prevChildName)) : "child[" + i2 + "] = " + child2 + "; [-1] = " + this.children[i2 - 1];
            prevChildName = childName;
        }
        int[] leafNumber = new int[1];
        this.processPointers(p -> {
            assert (p.myNode == this);
            leafNumber[0] = leafNumber[0] + 1;
        });
        int useCount = leafNumber[0];
        assert (useCount == 0 == (this.leaves == null)) : useCount + " - " + (this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((Object[])((VirtualFilePointerImpl[])this.leaves)));
        if (this.myFileOrUrl instanceof String) {
            String nameFromPath;
            String myPath = VfsUtilCore.urlToPath((String)this.myUrl());
            String string = nameFromPath = this.nameId == -2 || myPath.endsWith("!/") ? "!/" : PathUtil.getFileName((String)myPath);
            if (!myPath.isEmpty() && nameFromPath.isEmpty()) {
                nameFromPath = "/";
            }
            assert (StringUtilRt.equal((CharSequence)nameFromPath, (CharSequence)name, (boolean)SystemInfo.isFileSystemCaseSensitive)) : "fileAndUrl: " + this.myFileOrUrl + "; but this: " + this + "; nameFromPath: " + nameFromPath + "; name: " + name + "; myPath: " + myPath + "; url: " + this.myUrl() + ";";
            if (myFile != null) {
                String fileName;
                String string2 = fileName = myFile.getParent() == null && myFile.getFileSystem() instanceof ArchiveFileSystem ? "!/" : myFile.getName();
                assert (fileName.equals(name)) : "fileAndUrl: " + this.myFileOrUrl + "; but this: " + this;
                assert (myFile.getFileSystem() == this.myFS);
            }
        }
    }

    void update(@NotNull FilePartNode parent, @NotNull FilePartNodeRoot root) {
        Object fileOrUrl = this.myFileOrUrl;
        VirtualFile file2 = FilePartNode.myFile(fileOrUrl);
        boolean changed2 = false;
        boolean nameChanged = false;
        boolean fileIsValid = false;
        if (file2 != null) {
            fileIsValid = file2.isValid();
            if (fileIsValid && file2.getParent() == null && file2.getFileSystem() instanceof ArchiveFileSystem) {
                VirtualFile local = ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2);
                boolean bl = fileIsValid = local != null;
            }
            if (!fileIsValid) {
                file2 = null;
                changed2 = true;
            }
        }
        Object parentFileOrUrl = parent.myFileOrUrl;
        String myName = this.getName().toString();
        Object url = null;
        String parentUrl = null;
        VirtualFile parentFile = FilePartNode.myFile(parentFileOrUrl);
        if (file2 == null) {
            VirtualFile virtualFile = file2 = parentFile == null || !parentFile.isValid() ? null : FilePartNode.findChildThroughJar(parentFile, myName, this.myFS);
            if (file2 == null) {
                parentUrl = FilePartNode.myUrl(parentFileOrUrl);
                url = FilePartNode.childUrl(parentUrl, myName, this.myFS);
                nameChanged = !Comparing.strEqual((String)url, (String)FilePartNode.myUrl(fileOrUrl));
                changed2 |= nameChanged;
            } else {
                changed2 = true;
            }
            boolean bl = fileIsValid = file2 != null && file2.isValid();
        }
        if (parent.nameId != -1 && !(parentFileOrUrl instanceof VirtualFile) && file2 != null) {
            file2 = null;
            fileIsValid = false;
            url = FilePartNode.myUrl(fileOrUrl);
        }
        if (file2 != null) {
            if (fileIsValid) {
                nameChanged = !StringUtil.equals((CharSequence)file2.getNameSequence(), (CharSequence)myName);
                changed2 |= nameChanged;
            } else {
                file2 = null;
                changed2 = true;
                url = FilePartNode.myUrl(fileOrUrl);
            }
        }
        VirtualFile result2 = file2 == null ? url : file2;
        boolean bl = !Objects.equals(fileOrUrl, result2);
        FilePartNode thisNode = this;
        if (changed2 |= bl) {
            this.myFileOrUrl = result2;
            if (file2 != null && (this instanceof UrlPartNode || nameChanged)) {
                thisNode = this.replaceWithFPPN(file2, parent);
            }
        }
        if (file2 != null && !Objects.equals(FilePartNode.getParentThroughJar(file2, this.myFS), parentFile)) {
            FilePartNode newNode = root.findOrCreateByFile((VirtualFile)file2).node;
            this.processPointers(p -> newNode.addLeaf((VirtualFilePointerImpl)((Object)p)));
            newNode.children = this.children;
            this.children = EMPTY_ARRAY;
            changed2 = true;
            parentUrl = FilePartNode.myUrl(parentFileOrUrl);
            String myOldPath = VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl, myName, this.myFS));
            root.removeEmptyNodesByPath(FilePartNodeRoot.splitNames(myOldPath));
            thisNode = newNode;
            nameChanged = true;
        }
        if (nameChanged) {
            String myOldPath = VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl == null ? FilePartNode.myUrl(parentFileOrUrl) : parentUrl, myName, this.myFS));
            String myNewPath = VfsUtilCore.urlToPath((String)FilePartNode.myUrl(result2));
            thisNode.fixUrlPartNodes(myOldPath, myNewPath);
        }
        if (changed2) {
            for (FilePartNode child2 : thisNode.children) {
                child2.update(thisNode, root);
            }
        }
    }

    private void fixUrlPartNodes(@NotNull String oldPath, @NotNull String newPath) {
        if (this instanceof UrlPartNode) {
            String protocol = this.myFS.getProtocol();
            String myUrl = this.myUrl();
            if (StringUtil.startsWith((CharSequence)myUrl, (int)(protocol.length() + "://".length()), (CharSequence)oldPath)) {
                this.myFileOrUrl = protocol + "://" + newPath + myUrl.substring(protocol.length() + "://".length() + oldPath.length());
            }
        }
        for (FilePartNode child2 : this.children) {
            child2.fixUrlPartNodes(oldPath, newPath);
        }
    }

    @NotNull
    private FilePartNode replaceWithFPPN(@NotNull VirtualFile file2, @NotNull FilePartNode parent) {
        int nameId = FilePartNode.getNameId(file2);
        parent.children = (FilePartNode[])ArrayUtil.remove((Object[])parent.children, (Object)this);
        FilePartNode newNode = parent.findChildByNameId(file2, nameId, true, (NewVirtualFileSystem)file2.getFileSystem());
        newNode.children = this.children;
        this.processPointers(pointer -> newNode.addLeaf((VirtualFilePointerImpl)((Object)pointer)));
        this.leaves = null;
        return newNode;
    }

    @NotNull
    static String childUrl(@NotNull String parentUrl, @NotNull CharSequence childName, @NotNull NewVirtualFileSystem fs) {
        if (childName.equals("!/") && fs instanceof ArchiveFileSystem) {
            return VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + childName;
        }
        return parentUrl.isEmpty() ? VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)childName.toString()) : VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + '/' + childName;
    }

    private void associate(@Nullable Object leaves) {
        this.leaves = leaves;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)((Object)leaves)).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
    }

    VirtualFilePointerImpl getPointer(VirtualFilePointerListener listener2) {
        VirtualFilePointerImpl[] array2;
        Object leaves = this.leaves;
        if (leaves == null) {
            return null;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            VirtualFilePointerImpl leaf = (VirtualFilePointerImpl)((Object)leaves);
            return leaf.myListener == listener2 ? leaf : null;
        }
        for (VirtualFilePointerImpl pointer : array2 = (VirtualFilePointerImpl[])leaves) {
            if (pointer.myListener != listener2) continue;
            return pointer;
        }
        return null;
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        this.processPointers(p -> {
            if (p.myNode != null) {
                outList.add((VirtualFilePointerImpl)((Object)p));
            }
        });
    }

    void processPointers(@NotNull Consumer<? super VirtualFilePointerImpl> processor2) {
        VirtualFilePointerImpl[] pointers2;
        Object leaves = this.leaves;
        if (leaves == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            processor2.accept((VirtualFilePointerImpl)((Object)leaves));
            return;
        }
        for (VirtualFilePointerImpl pointer : pointers2 = (VirtualFilePointerImpl[])leaves) {
            processor2.accept(pointer);
        }
    }

    static VirtualFile getParentThroughJar(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        VirtualFile parent = file2.getParent();
        if (parent == null && fs instanceof ArchiveFileSystem) {
            parent = ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return parent;
    }

    static VirtualFile findChildThroughJar(@NotNull VirtualFile file2, @NotNull String name, @NotNull NewVirtualFileSystem childFs) {
        VirtualFile child2 = name.equals("!/") && childFs instanceof ArchiveFileSystem ? ((ArchiveFileSystem)childFs).getRootByLocal(file2) : file2.findChild(name);
        return child2;
    }

    boolean removeEmptyNodesByFile(@NotNull List<VirtualFile> parts) {
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        VirtualFile file2 = parts.remove(parts.size() - 1);
        FilePartNode child2 = this.findChildByNameId(null, FilePartNode.getNameId(file2), false, (NewVirtualFileSystem)file2.getFileSystem());
        if (child2 == null) {
            return false;
        }
        boolean toRemove2 = child2.removeEmptyNodesByFile(parts);
        if (toRemove2) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child2);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }

    boolean removeEmptyNodesByPath(@NotNull List<String> parts) {
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        String name = parts.remove(parts.size() - 1);
        int index = this.binarySearchChildByName(name);
        if (index < 0) {
            return false;
        }
        FilePartNode child2 = this.children[index];
        boolean toRemove2 = child2.removeEmptyNodesByPath(parts);
        if (toRemove2) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child2);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }
}

