/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerPopupRenderer
extends LineStatusMarkerRenderer {
    public LineStatusMarkerPopupRenderer(@NotNull LineStatusTrackerBase<?> tracker) {
        super(tracker);
    }

    @Override
    protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        return LineStatusMarkerPopupRenderer.isInsideMarkerArea(e);
    }

    @Override
    protected void doAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        Range range2 = ranges.get(0);
        if (ranges.size() > 1) {
            this.scrollAndShow(editor, range2);
        } else {
            this.showHint(editor, range2, e);
        }
    }

    @NotNull
    protected abstract List<AnAction> createToolbarActions(@NotNull Editor var1, @NotNull Range var2, @Nullable Point var3);

    @NotNull
    protected FileType getFileType() {
        return PlainTextFileType.INSTANCE;
    }

    private static boolean isShowInnerDifferences() {
        return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
    }

    @Nullable
    protected JComponent createAdditionalInfoPanel(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition, @NotNull Disposable disposable2) {
        return null;
    }

    public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
        if (!this.myTracker.isValid()) {
            return;
        }
        Document document = this.myTracker.getDocument();
        int line = Math.min(range2.getType() == 3 ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        editor.getCaretModel().moveToOffset(lastOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.showAfterScroll(editor, range2);
    }

    public void showAfterScroll(@NotNull Editor editor, @NotNull Range range2) {
        editor.getScrollingModel().runActionOnScrollingFinished(() -> {
            Object newRange = this.myTracker.findRange(range2);
            if (newRange != null) {
                this.showHintAt(editor, (Range)newRange, null);
            }
        });
    }

    public void showHint(@NotNull Editor editor, @NotNull Range range2, @NotNull MouseEvent e) {
        JComponent comp = (JComponent)e.getComponent();
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(editor, range2, point);
        e.consume();
    }

    public void showHintAt(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
        if (!this.myTracker.isValid()) {
            return;
        }
        Disposable disposable2 = Disposer.newDisposable();
        List<DiffFragment> wordDiff = this.computeWordDiff(range2);
        this.installMasterEditorHighlighters(editor, range2, wordDiff, disposable2);
        JComponent editorComponent = this.createEditorComponent(editor, range2, wordDiff);
        ActionToolbar toolbar = this.buildToolbar(editor, range2, mousePosition, disposable2);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        JComponent additionalInfoPanel = this.createAdditionalInfoPanel(editor, range2, mousePosition, disposable2);
        PopupPanel popupPanel = new PopupPanel(editor, toolbar, editorComponent, additionalInfoPanel);
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener2 = __ -> Disposer.dispose((Disposable)disposable2);
        hint.addHintListener(closeListener2);
        int line = editor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, editor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = editor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 1064;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, -1, false, new HintHint(editor, point));
        ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(EditorHintListener.TOPIC, (project, newHint, newHintFlags) -> {
            PopupPanel newPopupPanel;
            if (newHint.getComponent() instanceof PopupPanel && (newPopupPanel = (PopupPanel)newHint.getComponent()).getEditor().equals(editor)) {
                hint.hide();
            }
        });
        if (!hint.isVisible()) {
            closeListener2.hintHidden(new EventObject(hint));
        }
    }

    @Nullable
    private List<DiffFragment> computeWordDiff(@NotNull Range range2) {
        if (!LineStatusMarkerPopupRenderer.isShowInnerDifferences()) {
            return null;
        }
        if (range2.getType() != 1) {
            return null;
        }
        CharSequence vcsContent = this.getVcsContent(range2);
        CharSequence currentContent = this.getCurrentContent(range2);
        return (List)BackgroundTaskUtil.tryComputeFast(indicator -> ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator), 200L);
    }

    private void installMasterEditorHighlighters(@NotNull Editor editor, @NotNull Range range2, @Nullable List<? extends DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (wordDiff == null) {
            return;
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        int currentStartShift = this.getCurrentTextRange(range2).getStartOffset();
        for (DiffFragment diffFragment : wordDiff) {
            int currentStart = currentStartShift + diffFragment.getStartOffset2();
            int currentEnd = currentStartShift + diffFragment.getEndOffset2();
            TextDiffType type = DiffUtil.getDiffType(diffFragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, currentStart, currentEnd, type));
        }
        Disposer.register((Disposable)parentDisposable, () -> highlighters.forEach(RangeMarker::dispose));
    }

    @Nullable
    private JComponent createEditorComponent(@NotNull Editor editor, @NotNull Range range2, @Nullable List<? extends DiffFragment> wordDiff) {
        if (range2.getType() == 2) {
            return null;
        }
        TextRange vcsTextRange = this.getVcsTextRange(range2);
        String content2 = this.getVcsContent(range2).toString();
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        EditorHighlighter highlighter = highlighterFactory.createEditorHighlighter(this.myTracker.getProject(), LineStatusMarkerPopupRenderer.getFileName(this.myTracker.getDocument()));
        highlighter.setText(this.myTracker.getVcsDocument().getImmutableCharSequence());
        FragmentedEditorHighlighter fragmentedHighlighter = new FragmentedEditorHighlighter(highlighter, vcsTextRange);
        Color backgroundColor = EditorFragmentComponent.getBackgroundColor(editor, true);
        EditorTextField field = new EditorTextField(content2);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.setFontInheritedFromLAF(false);
        field.addSettingsProvider(uEditor -> {
            uEditor.setVerticalScrollbarVisible(true);
            uEditor.setHorizontalScrollbarVisible(true);
            uEditor.setRendererMode(true);
            uEditor.setBorder(null);
            uEditor.setColorsScheme(editor.getColorsScheme());
            uEditor.setBackgroundColor(backgroundColor);
            uEditor.getSettings().setCaretRowShown(false);
            uEditor.getSettings().setTabSize(editor.getSettings().getTabSize(editor.getProject()));
            uEditor.getSettings().setUseTabCharacter(editor.getSettings().isUseTabCharacter(editor.getProject()));
            uEditor.setHighlighter((EditorHighlighter)fragmentedHighlighter);
            if (wordDiff != null) {
                for (DiffFragment fragment : wordDiff) {
                    int vcsStart = fragment.getStartOffset1();
                    int vcsEnd = fragment.getEndOffset1();
                    TextDiffType type = DiffUtil.getDiffType(fragment);
                    DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type);
                }
            }
        });
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)((Object)field));
        panel2.setBorder(EditorFragmentComponent.createEditorFragmentBorder(editor));
        panel2.setBackground(backgroundColor);
        DataManager.registerDataProvider((JComponent)panel2, data2 -> {
            if (CommonDataKeys.HOST_EDITOR.is(data2)) {
                return field.getEditor();
            }
            return null;
        });
        return panel2;
    }

    private static String getFileName(@NotNull Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return "";
        }
        return file2.getName();
    }

    @NotNull
    private ActionToolbar buildToolbar(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition, @NotNull Disposable parentDisposable) {
        List<AnAction> actions = this.createToolbarActions(editor, range2, mousePosition);
        JComponent editorComponent = editor.getComponent();
        for (AnAction action2 : actions) {
            DiffUtil.registerAction(action2, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, () -> ActionUtil.getActions((JComponent)editorComponent).removeAll(actions));
        return ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
    }

    @NotNull
    private CharSequence getCurrentContent(Range range2) {
        return DiffUtil.getLinesContent(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
    }

    @NotNull
    private CharSequence getVcsContent(Range range2) {
        return DiffUtil.getLinesContent(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
    }

    @NotNull
    private TextRange getCurrentTextRange(@NotNull Range range2) {
        return DiffUtil.getLinesRange(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
    }

    @NotNull
    private TextRange getVcsTextRange(@NotNull Range range2) {
        return DiffUtil.getLinesRange(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
    }

    public class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware,
    LightEditCompatible {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final Range myRange;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Editor editor, @Nullable Range range2, Point position) {
            super(DiffBundle.message((String)"highlight.words", (Object[])new Object[0]), null, AllIcons.Actions.Highlighting);
            this.myEditor = editor;
            this.myRange = range2;
            this.myMousePosition = position;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (!LineStatusMarkerPopupRenderer.this.myTracker.isValid()) {
                return;
            }
            DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            if (newRange != null) {
                LineStatusMarkerPopupRenderer.this.showHintAt(this.myEditor, (Range)newRange, this.myMousePosition);
            }
        }
    }

    public class ShowLineStatusRangeDiffAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowLineStatusRangeDiffAction(@NotNull Editor editor, Range range2) {
            super(editor, range2, "Diff.ShowDiff");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            return true;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Range ourRange = this.expand(range2, LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument());
            DiffContent vcsContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getVcsTextRange(ourRange));
            DiffContent currentContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getCurrentTextRange(ourRange));
            SimpleDiffRequest request2 = new SimpleDiffRequest(DiffBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, DiffBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), DiffBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
            DiffManager.getInstance().showDiff(LineStatusMarkerPopupRenderer.this.myTracker.getProject(), (DiffRequest)request2);
        }

        @NotNull
        private DiffContent createDiffContent(@NotNull Document document, @Nullable VirtualFile highlightFile, @NotNull TextRange textRange) {
            Project project = LineStatusMarkerPopupRenderer.this.myTracker.getProject();
            DocumentContent content2 = DiffContentFactory.getInstance().create(project, document, highlightFile);
            return DiffContentFactory.getInstance().createFragment(project, content2, textRange);
        }

        @NotNull
        private Range expand(@NotNull Range range2, @NotNull Document document, @NotNull Document uDocument) {
            boolean canExpandBefore = range2.getLine1() != 0 && range2.getVcsLine1() != 0;
            boolean canExpandAfter = range2.getLine2() < DiffUtil.getLineCount(document) && range2.getVcsLine2() < DiffUtil.getLineCount(uDocument);
            int offset1 = range2.getLine1() - (canExpandBefore ? 1 : 0);
            int uOffset1 = range2.getVcsLine1() - (canExpandBefore ? 1 : 0);
            int offset2 = range2.getLine2() + (canExpandAfter ? 1 : 0);
            int uOffset2 = range2.getVcsLine2() + (canExpandAfter ? 1 : 0);
            return new Range(offset1, offset2, uOffset1, uOffset2);
        }
    }

    public class CopyLineStatusRangeAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public CopyLineStatusRangeAction(@NotNull Editor editor, Range range2) {
            super(editor, range2, "$Copy");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            return 3 == range2.getType() || 1 == range2.getType();
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            String content2 = LineStatusMarkerPopupRenderer.this.getVcsContent(range2) + "\n";
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content2));
        }
    }

    public class ShowPrevChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowPrevChangeMarkerAction(@NotNull Editor editor, Range range2) {
            super(editor, range2, "VcsShowPrevChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            return LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1());
            if (targetRange != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }
    }

    public class ShowNextChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowNextChangeMarkerAction(@NotNull Editor editor, Range range2) {
            super(editor, range2, "VcsShowNextChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            return LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1());
            if (targetRange != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }
    }

    protected abstract class RangeMarkerAction
    extends DumbAwareAction {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;

        public RangeMarkerAction(@NotNull Editor editor, @Nullable @NonNls Range range2, String actionId) {
            this.myRange = range2;
            this.myEditor = editor;
            if (actionId != null) {
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            e.getPresentation().setEnabled(newRange != null && !this.myEditor.isDisposed() && this.isEnabled(this.myEditor, (Range)newRange));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            if (newRange != null) {
                this.actionPerformed(this.myEditor, (Range)newRange);
            }
        }

        protected abstract boolean isEnabled(@NotNull Editor var1, @NotNull Range var2);

        protected abstract void actionPerformed(@NotNull Editor var1, @NotNull Range var2);
    }

    private static class PopupPanel
    extends JPanel {
        @Nullable
        private final JComponent myEditorComponent;
        @NotNull
        private final Editor myEditor;

        PopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfo) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.myEditor = editor;
            this.myEditorComponent = editorComponent;
            boolean isEditorVisible = this.myEditorComponent != null;
            JBColor borderColor = new JBColor((Color)Gray._206, (Color)Gray._75);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel((Component)toolbarComponent);
            Border outsideToolbarBorder = JBUI.Borders.customLine((Color)borderColor, (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
            JBEmptyBorder insideToolbarBorder = JBUI.Borders.empty((int)1, (int)5);
            toolbarPanel.setBorder(BorderFactory.createCompoundBorder(outsideToolbarBorder, (Border)insideToolbarBorder));
            if (additionalInfo != null) {
                toolbarPanel.add((Component)additionalInfo, "East");
            }
            if (this.myEditorComponent != null) {
                Border outsideEditorBorder = JBUI.Borders.customLine((Color)borderColor, (int)1);
                Border insideEditorBorder = JBUI.Borders.empty((int)2);
                this.myEditorComponent.setBorder(BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder));
            }
            JPanel emptyPanel = new JPanel();
            emptyPanel.setOpaque(false);
            emptyPanel.setPreferredSize(new Dimension());
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.setOpaque(false);
            topPanel.add((Component)toolbarPanel, "West");
            topPanel.add((Component)emptyPanel, "Center");
            this.add((Component)topPanel, "North");
            if (this.myEditorComponent != null) {
                this.add((Component)this.myEditorComponent, "Center");
            }
            MouseAdapter listener2 = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }
            };
            emptyPanel.addMouseListener(listener2);
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        private static void transferEvent(MouseEvent e, Editor editor) {
            editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
        }

        int getEditorTextOffset() {
            return EditorFragmentComponent.createEditorFragmentBorder((Editor)this.myEditor).getBorderInsets((Component)this.myEditorComponent).left;
        }

        @Override
        public Dimension getPreferredSize() {
            int gap = JBUI.scale((int)10);
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)this.myEditor.getComponent());
            Rectangle maxSize2 = new Rectangle(screenRectangle.width - gap, screenRectangle.height - gap);
            Dimension size = super.getPreferredSize();
            if (size.width > maxSize2.width) {
                size.width = maxSize2.width;
                size.height += JBUI.scale((int)20);
            }
            if (size.height > maxSize2.height) {
                size.height = maxSize2.height;
            }
            return size;
        }
    }
}

