/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.Urls;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private final PluginId myPluginId;
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final boolean myLicenseOptional;
    private final String myDescription;
    @NotNull
    private final List<IdeaPluginDependency> myDependencies;
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    private String myPluginVersion;
    private IdeaPluginDescriptor myDescriptor;
    private File myFile;
    private Path myOldFile;
    private MarketplaceRequests myMarketplaceRequests = MarketplaceRequests.getInstance();
    private boolean myShownErrors;

    private PluginDownloader(@NotNull IdeaPluginDescriptor descriptor2, @NotNull String url, @Nullable BuildNumber buildNumber) {
        this.myPluginId = descriptor2.getPluginId();
        this.myPluginName = descriptor2.getName();
        this.myProductCode = descriptor2.getProductCode();
        this.myReleaseDate = descriptor2.getReleaseDate();
        this.myReleaseVersion = descriptor2.getReleaseVersion();
        this.myLicenseOptional = descriptor2.isLicenseOptional();
        this.myDescription = descriptor2.getDescription();
        this.myDependencies = descriptor2.getDependencies();
        this.myPluginUrl = url;
        this.myBuildNumber = buildNumber;
        this.myPluginVersion = descriptor2.getVersion();
        this.myDescriptor = descriptor2;
    }

    public void setMarketplaceRequests(MarketplaceRequests requests) {
        this.myMarketplaceRequests = requests;
    }

    @Deprecated
    @NotNull
    public String getPluginId() {
        return this.myPluginId.getIdString();
    }

    @NotNull
    public PluginId getId() {
        return this.myPluginId;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NotNull
    public String getPluginName() {
        return this.myPluginName != null ? this.myPluginName : this.myPluginId.getIdString();
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isLicenseOptional() {
        return this.myLicenseOptional;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        return this.prepareToInstallAndLoadDescriptor(indicator) != null;
    }

    @Nullable
    public IdeaPluginDescriptorImpl prepareToInstallAndLoadDescriptor(@NotNull ProgressIndicator indicator) throws IOException {
        return this.prepareToInstallAndLoadDescriptor(indicator, true);
    }

    @Nullable
    public IdeaPluginDescriptorImpl prepareToInstallAndLoadDescriptor(@NotNull ProgressIndicator indicator, boolean showMessageOnError) throws IOException {
        this.myShownErrors = false;
        if (this.myFile != null) {
            IdeaPluginDescriptorImpl actualDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
            this.myDescriptor = actualDescriptor;
            return actualDescriptor;
        }
        IdeaPluginDescriptor descriptor2 = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManagerCore.isPluginInstalled(this.myPluginId)) {
            descriptor2 = PluginManagerCore.getPlugin(this.myPluginId);
            LOG.assertTrue(descriptor2 != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor2) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return null;
            }
            this.myOldFile = descriptor2.isBundled() ? null : descriptor2.getPluginPath();
        }
        String errorMessage = null;
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                this.myShownErrors = true;
                if (showMessageOnError) {
                    if (errorMessage == null) {
                        errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                    }
                    String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                    String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                    app.invokeLater(() -> Messages.showErrorDialog((String)text, (String)title), ModalityState.any());
                }
            }
            return null;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                return null;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor2 != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor2) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return null;
            }
            this.myDescriptor = actualDescriptor;
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return null;
            }
        }
        return actualDescriptor;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(String newPluginVersion, @NotNull IdeaPluginDescriptor existingPlugin) {
        int state = VersionComparatorUtil.compare((String)newPluginVersion, (String)existingPlugin.getVersion());
        if (state < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state = 1;
        }
        return state;
    }

    public void install() throws IOException {
        if (this.myFile == null) {
            throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
        }
        PluginInstaller.installAfterRestart(this.myFile, true, this.myOldFile, this.myDescriptor);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor, PluginManagerCore.isPluginInstalled(this.myDescriptor.getPluginId()), true);
        } else {
            InstalledPluginsState.addPreInstalledPlugin(this.myDescriptor);
        }
    }

    public boolean tryInstallWithoutRestart(@Nullable JComponent ownerComponent) {
        IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)this.myDescriptor;
        if (!DynamicPlugins.allowLoadUnloadWithoutRestart(descriptorImpl)) {
            return false;
        }
        if (this.myOldFile != null) {
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(this.myDescriptor.getPluginId());
            if (installedPlugin == null) {
                return false;
            }
            IdeaPluginDescriptorImpl installedPluginDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)installedPlugin);
            if (installedPluginDescriptor == null || !DynamicPlugins.unloadPlugin(installedPluginDescriptor, new DynamicPlugins.UnloadPluginOptions().withUpdate(true).withWaitForClassloaderUnload(true))) {
                return false;
            }
        }
        return PluginInstaller.installAndLoadDynamicPlugin(this.myFile, ownerComponent, descriptorImpl);
    }

    @NotNull
    private File downloadPlugin(@NotNull ProgressIndicator indicator) throws IOException {
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        return this.myMarketplaceRequests.download(this.myPluginUrl, indicator);
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        return PluginDownloader.createDownloader(descriptor2, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        String url;
        try {
            if (host != null && descriptor2 instanceof PluginNode) {
                url = ((PluginNode)descriptor2).getDownloadUrl();
                if (!new URI(url).isAbsolute()) {
                    url = new URL(new URL(host), url).toExternalForm();
                }
            } else {
                HashMap<String, String> parameters2 = new HashMap<String, String>();
                parameters2.put("id", descriptor2.getPluginId().getIdString());
                parameters2.put("build", PluginDownloader.getBuildNumberForDownload(buildNumber));
                parameters2.put("uuid", PermanentInstallationID.get());
                url = Urls.newFromEncoded((String)ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl()).addParameters(parameters2).toExternalForm();
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return new PluginDownloader(descriptor2, url, buildNumber);
    }

    @NotNull
    public static String getBuildNumberForDownload(@Nullable BuildNumber buildNumber) {
        return buildNumber != null ? buildNumber.asString() : MarketplaceRequests.getInstance().getBuildForPluginRepositoryRequests();
    }

    @NotNull
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor2 = downloader.getDescriptor();
        if (descriptor2 instanceof PluginNode) {
            return (PluginNode)descriptor2;
        }
        PluginNode node = new PluginNode(downloader.myPluginId);
        node.setName(downloader.getPluginName());
        node.setProductCode(downloader.getProductCode());
        node.setReleaseDate(downloader.getReleaseDate());
        node.setReleaseVersion(downloader.getReleaseVersion());
        node.setLicenseOptional(downloader.isLicenseOptional());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDependencies(downloader.myDependencies);
        node.setDescription(downloader.myDescription);
        return node;
    }
}

