/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateInfoKt;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\nH\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010(\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\f\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "blogPost", "", "getBlogPost", "()Ljava/lang/String;", "buttons", "", "Lcom/intellij/openapi/updateSettings/impl/ButtonInfo;", "getButtons", "()Ljava/util/List;", "downloadUrl", "getDownloadUrl", "message", "getMessage", "number", "getNumber", "patches", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "getPatches", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "target", "Lcom/intellij/openapi/util/BuildRange;", "getTarget", "()Lcom/intellij/openapi/util/BuildRange;", "version", "getVersion", "parseBuildNumber", "value", "parseDate", "toString", "intellij.platform.ide.impl"})
public final class BuildInfo {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final String blogPost;
    @Nullable
    private final Date releaseDate;
    @Nullable
    private final BuildRange target;
    @NotNull
    private final List<ButtonInfo> buttons;
    @NotNull
    private final List<PatchInfo> patches;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getBlogPost() {
        return this.blogPost;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final BuildRange getTarget() {
        return this.target;
    }

    @NotNull
    public final List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    @NotNull
    public final List<PatchInfo> getPatches() {
        return this.patches;
    }

    private final BuildNumber parseBuildNumber(String value2) {
        BuildNumber buildNumber = BuildNumber.fromString((String)value2);
        if (buildNumber == null) {
            Intrinsics.throwNpe();
        }
        BuildNumber buildNumber2 = buildNumber;
        CharSequence charSequence = buildNumber2.getProductCode();
        boolean bl = false;
        if (charSequence.length() == 0) {
            int[] nArray = buildNumber2.getComponents();
            buildNumber2 = new BuildNumber(ApplicationInfoImpl.getShadowInstance().getBuild().getProductCode(), Arrays.copyOf(nArray, nArray.length));
        }
        return buildNumber2;
    }

    private final Date parseDate(String value2) {
        Date date;
        if (value2 == null) {
            date = null;
        } else {
            Date date2;
            try {
                date2 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(value2);
            }
            catch (ParseException e) {
                Logger.getInstance(BuildInfo.class).info("invalid build release date: " + value2);
                date2 = null;
            }
            date = date2;
        }
        return date;
    }

    @Nullable
    public final String getDownloadUrl() {
        Object v0;
        block1: {
            Iterable iterable = this.buttons;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Object t;
                Object receiver = t = iterator2.next();
                boolean bl3 = false;
                if (!((ButtonInfo)receiver).isDownload()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ButtonInfo buttonInfo = v0;
        return buttonInfo != null ? buttonInfo.getUrl() : null;
    }

    @NotNull
    public String toString() {
        return this.number + '/' + this.version;
    }

    /*
     * WARNING - void declaration
     */
    public BuildInfo(@NotNull Element node) {
        Object object;
        Element p1;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object2;
        String string;
        Object object3;
        BuildInfo buildInfo;
        Object object4;
        block8: {
            Object object5;
            BuildInfo buildInfo2;
            block7: {
                void it;
                this.number = this.parseBuildNumber(UpdateInfoKt.access$getMandatoryAttributeValue(node, "fullNumber", "number"));
                buildInfo2 = this;
                object5 = node.getAttributeValue("apiVersion");
                if (object5 == null) break block7;
                object4 = object5;
                boolean bl = false;
                boolean bl2 = false;
                String string2 = object4;
                buildInfo = buildInfo2;
                boolean bl3 = false;
                object3 = BuildNumber.fromStringWithProductCode((String)it, (String)this.number.getProductCode());
                buildInfo2 = buildInfo;
                object5 = object3;
                if (object5 != null) break block8;
            }
            object5 = buildInfo2.apiVersion = this.number;
        }
        if ((string = node.getAttributeValue("version")) == null) {
            string = this.version = "";
        }
        if ((object2 = node.getChild("message")) == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        this.message = object2;
        Element element2 = node.getChild("blogPost");
        this.blogPost = element2 != null ? element2.getAttributeValue("url") : null;
        this.releaseDate = this.parseDate(node.getAttributeValue("releaseDate"));
        this.target = BuildRange.fromStrings((String)node.getAttributeValue("targetSince"), (String)node.getAttributeValue("targetUntil"));
        object4 = node.getChildren("button");
        buildInfo = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Element element3 = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object = new ButtonInfo(p1);
            object3.add(object);
        }
        object3 = (List)destination$iv$iv;
        buildInfo.buttons = object3;
        $this$map$iv = node.getChildren("patch");
        buildInfo = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p1 = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object = new PatchInfo(p1);
            object3.add(object);
        }
        buildInfo.patches = object3 = (List)destination$iv$iv;
    }
}

