/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaSourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaSourceRootProperties> {
    public JavaSourceRootEditHandlerBase(JpsModuleSourceRootType<JavaSourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaSourceRootProperties properties) {
        return properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
    }

    @Override
    @Nullable
    public Icon getRootFileLayerIcon(@NotNull JavaSourceRootProperties properties) {
        return AllIcons.Modules.SourceRootFileLayer;
    }

    @NotNull
    protected abstract Icon getGeneratedRootIcon();

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaSourceRootProperties properties) {
        String packagePrefix;
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(packagePrefix = properties.getPackagePrefix()).isEmpty()) {
            buffer.append(" (").append(packagePrefix).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback2) {
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.General.Inline_edit, AllIcons.General.Inline_edit_hovered, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), () -> {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            assert (properties != null);
            SourceRootPropertiesDialog dialog2 = new SourceRootPropertiesDialog(parentComponent, properties);
            if (dialog2.showAndGet()) {
                callback2.onSourceRootPropertiesChanged(folder);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)iconComponent, "Center");
        panel2.add(Box.createHorizontalStrut(3), "East");
        return panel2;
    }

    private static class SourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myPackagePrefixField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaSourceRootProperties myProperties;

        private SourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaSourceRootProperties properties) {
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myPackagePrefixField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(ProjectBundle.message((String)"checkbox.for.generated.sources", (Object[])new Object[0]));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent(ProjectBundle.message((String)"label.package.prefix", (Object[])new Object[0]), (JComponent)this.myPackagePrefixField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myPackagePrefixField.setText(this.myProperties.getPackagePrefix());
            this.myPackagePrefixField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPackagePrefixField;
        }

        protected void doOKAction() {
            this.myProperties.setPackagePrefix(this.myPackagePrefixField.getText().trim());
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }
    }
}

