/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public abstract class RootModelBase
implements ModuleRootModel {
    public VirtualFile @NotNull [] getContentRoots() {
        Collection<ContentEntry> content2 = this.getContent();
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(content2.size());
        for (ContentEntry contentEntry : content2) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public String @NotNull [] getContentRootUrls() {
        Collection<ContentEntry> content2 = this.getContent();
        if (content2.isEmpty()) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result2 = new ArrayList<String>(content2.size());
        for (ContentEntry contentEntry : content2) {
            result2.add(contentEntry.getUrl());
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    public String @NotNull [] getExcludeRootUrls() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            result2.addAll(contentEntry.getExcludeFolderUrls());
        }
        return ArrayUtilRt.toStringArray((Collection)result2);
    }

    public VirtualFile @NotNull [] getExcludeRoots() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result2, contentEntry.getExcludeFolderFiles());
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    public String @NotNull [] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders2;
            for (SourceFolder sourceFolder : sourceFolders2 = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result2.add(sourceFolder.getUrl());
            }
        }
        return ArrayUtilRt.toStringArray((Collection)result2);
    }

    public VirtualFile @NotNull [] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    public VirtualFile @NotNull [] getSourceRoots(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders2;
            for (SourceFolder sourceFolder : sourceFolders2 = contentEntry.getSourceFolders()) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null || !includingTests && sourceFolder.isTestSource()) continue;
                result2.add(file2);
            }
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.getSourceRoots(Collections.singleton(rootType));
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            List sourceFolders2 = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders2) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null) continue;
                result2.add(file2);
            }
        }
        return result2;
    }

    public ContentEntry @NotNull [] getContentEntries() {
        Collection<ContentEntry> content2 = this.getContent();
        return content2.toArray(new ContentEntry[0]);
    }

    protected abstract Collection<ContentEntry> getContent();

    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this, null);
    }

    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        Object result2 = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result2 = orderEntry.accept(policy, result2);
        }
        return result2;
    }

    public String @NotNull [] getDependencyModuleNames() {
        List result2 = (List)this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process((RootPolicy)new CollectDependentModules(), new ArrayList());
        return ArrayUtilRt.toStringArray((Collection)result2);
    }

    public Module @NotNull [] getModuleDependencies() {
        return this.getModuleDependencies(true);
    }

    public Module @NotNull [] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries = this.getOrderEntries();
        List result2 = null;
        for (OrderEntry entry : entries) {
            Module module;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(module);
        }
        return result2 == null ? Module.EMPTY_ARRAY : result2.toArray(Module.EMPTY_ARRAY);
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            arrayList.add(moduleOrderEntry.getModuleName());
            return arrayList;
        }
    }
}

