/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFileIndexFacade
extends FileIndexFacade {
    private final ProjectFileIndex myFileIndex;

    protected ProjectFileIndexFacade(@NotNull Project project) {
        super(project);
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInContent(file2);
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInSource(file2);
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInSourceContent(file2);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInLibraryClasses(file2);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        return this.myFileIndex.isInLibrarySource(file2);
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        return this.myFileIndex.isExcluded(file2);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        return this.myFileIndex.isUnderIgnored(file2);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        return this.myFileIndex.getModuleForFile(file2);
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        DirectoryIndex dirIndex = DirectoryIndex.getInstance(this.myProject);
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (!dirIndex.getInfoForFile(childDir).isInProject(childDir)) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        return ProjectRootManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        return ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions();
    }

    public boolean isInProjectScope(@NotNull VirtualFile file2) {
        DirectoryInfo info = ((ProjectFileIndexImpl)this.myFileIndex).getInfoForFileOrDirectory(file2);
        if (!info.isInProject(file2)) {
            return false;
        }
        if (info.hasLibraryClassRoot() && !info.isInModuleSource(file2)) {
            return false;
        }
        return info.getModule() != null;
    }
}

