/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class OrderRootsCache {
    private final AtomicReference<ConcurrentMap<CacheKey, VirtualFilePointerContainer>> myRoots = new AtomicReference();
    private final Disposable myParentDisposable;
    private Disposable myRootsDisposable;
    private static final VirtualFilePointerContainer EMPTY = (VirtualFilePointerContainer)ObjectUtils.sentinel((String)"Empty roots container", VirtualFilePointerContainer.class);

    @ApiStatus.Internal
    public OrderRootsCache(@NotNull Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
        this.disposePointers();
    }

    private void disposePointers() {
        if (this.myRootsDisposable != null) {
            Disposer.dispose((Disposable)this.myRootsDisposable);
        }
        if (!Disposer.isDisposing((Disposable)this.myParentDisposable)) {
            this.myRootsDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myRootsDisposable);
        }
    }

    private VirtualFilePointerContainer createContainer(@NotNull Collection<String> urls) {
        VirtualFilePointerContainer container2;
        if (urls.isEmpty()) {
            container2 = EMPTY;
        } else {
            container2 = VirtualFilePointerManager.getInstance().createContainer(this.myRootsDisposable);
            ((VirtualFilePointerContainerImpl)container2).addAll(urls);
        }
        return container2;
    }

    private VirtualFilePointerContainer getOrComputeContainer(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> rootUrlsComputer) {
        VirtualFilePointerContainer cached;
        ConcurrentMap map2 = this.myRoots.get();
        CacheKey key = new CacheKey(rootType, flags);
        VirtualFilePointerContainer virtualFilePointerContainer = cached = map2 == null ? null : (VirtualFilePointerContainer)map2.get(key);
        if (cached == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myRoots, new ConcurrentHashMap());
            cached = map2.computeIfAbsent(key, __ -> this.createContainer((Collection)rootUrlsComputer.get()));
        }
        return cached == EMPTY ? null : cached;
    }

    VirtualFile @NotNull [] getOrComputeRoots(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container2 = this.getOrComputeContainer(rootType, flags, computer);
        return container2 == null ? VirtualFile.EMPTY_ARRAY : container2.getFiles();
    }

    String @NotNull [] getOrComputeUrls(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container2 = this.getOrComputeContainer(rootType, flags, computer);
        return container2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container2.getUrls();
    }

    @ApiStatus.Internal
    public void clearCache() {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.disposePointers();
        this.myRoots.set(null);
    }

    private static final class CacheKey {
        private final OrderRootType myRootType;
        private final int myFlags;

        private CacheKey(@NotNull OrderRootType rootType, int flags) {
            this.myRootType = rootType;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.myFlags == cacheKey.myFlags && this.myRootType.equals((Object)cacheKey.myRootType);
        }

        public int hashCode() {
            return 31 * this.myRootType.hashCode() + this.myFlags;
        }
    }
}

