/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ModuleLibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance(LibraryOrderEntryImpl.class);
    @NotNull
    private final Library myLibrary;
    @NonNls
    public static final String ENTRY_TYPE = "module-library";
    private boolean myExported;
    @NonNls
    private static final String EXPORTED_ATTR = "exported";

    private ModuleLibraryOrderEntryImpl(@NotNull Library library, @NotNull RootModelImpl rootModel, boolean isExported, @NotNull DependencyScope scope) {
        super(rootModel, ProjectRootManagerImpl.getInstanceImpl(rootModel.getProject()));
        this.myLibrary = ((LibraryImpl)library).cloneLibrary(this.getRootModel());
        this.doinit();
        this.myExported = isExported;
        this.myScope = scope;
    }

    ModuleLibraryOrderEntryImpl(String name, PersistentLibraryKind kind, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, ProjectModelExternalSource externalSource) {
        super(rootModel, projectRootManager);
        this.myLibrary = LibraryTableImplUtil.createModuleLevelLibrary(name, kind, this.getRootModel(), externalSource);
        this.doinit();
    }

    ModuleLibraryOrderEntryImpl(@NotNull Element element2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        super(rootModel, projectRootManager);
        LOG.assertTrue(ENTRY_TYPE.equals(element2.getAttributeValue("type")));
        this.myExported = element2.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal((Element)element2);
        this.myLibrary = LibraryTableImplUtil.loadLibrary(element2, this.getRootModel());
        this.doinit();
    }

    private void doinit() {
        Disposer.register((Disposable)this, (Disposable)this.myLibrary);
        this.init();
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myLibrary.getRootProvider();
    }

    @NotNull
    public Library getLibrary() {
        return this.myLibrary;
    }

    public boolean isModuleLevel() {
        return true;
    }

    public String getLibraryName() {
        return this.myLibrary.getName();
    }

    public String getLibraryLevel() {
        return "module";
    }

    @NotNull
    public String getPresentableName() {
        String name = this.myLibrary.getName();
        if (name != null) {
            return name;
        }
        if (this.myLibrary instanceof LibraryEx && ((LibraryEx)this.myLibrary).isDisposed()) {
            return "<unknown>";
        }
        String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String url = urls[0];
            return PathUtil.toPresentableUrl((String)url);
        }
        return ProjectModelBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
    }

    public boolean isValid() {
        return !this.isDisposed();
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }

    public boolean isSynthetic() {
        return true;
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull ModifiableRootModel rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        return new ModuleLibraryOrderEntryImpl(this.myLibrary, (RootModelImpl)rootModel, this.myExported, this.myScope);
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        Element element2 = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        if (this.myExported) {
            element2.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element2);
        this.myLibrary.writeExternal(element2);
        rootElement.addContent(element2);
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value2) {
        this.getRootModel().assertWritable();
        this.myExported = value2;
    }

    @NotNull
    public DependencyScope getScope() {
        return this.myScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }
}

