/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SdkFinder;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModuleJdkOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements WritableOrderEntry,
ClonableOrderEntry,
ModuleJdkOrderEntry,
ProjectJdkTable.Listener {
    @NonNls
    public static final String ENTRY_TYPE = "jdk";
    @NonNls
    private static final String JDK_NAME_ATTR = "jdkName";
    @NonNls
    private static final String JDK_TYPE_ATTR = "jdkType";
    @Nullable
    private Sdk myJdk;
    @Nullable
    private String myJdkName;
    private String myJdkType;

    ModuleJdkOrderEntryImpl(@NotNull Sdk projectJdk, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.init(projectJdk, null, null);
    }

    ModuleJdkOrderEntryImpl(@NotNull Element element2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        super(rootModel, projectRootManager);
        Sdk jdkByName;
        if (!element2.getName().equals("orderEntry")) {
            throw new InvalidDataException();
        }
        Attribute jdkNameAttribute = element2.getAttribute(JDK_NAME_ATTR);
        if (jdkNameAttribute == null) {
            throw new InvalidDataException();
        }
        String jdkName = jdkNameAttribute.getValue();
        String jdkType = element2.getAttributeValue(JDK_TYPE_ATTR);
        Sdk sdk2 = jdkByName = jdkType == null ? null : ModuleJdkOrderEntryImpl.findJdk(jdkName, jdkType);
        if (jdkByName == null) {
            this.init(null, jdkName, jdkType);
        } else {
            this.init(jdkByName, null, null);
        }
    }

    @Nullable
    private static Sdk findJdk(@NotNull String sdkName, @NotNull String sdkType) {
        for (SdkFinder sdkFinder : (SdkFinder[])SdkFinder.EP_NAME.getExtensions()) {
            Sdk sdk2 = sdkFinder.findSdk(sdkName, sdkType);
            if (sdk2 == null) continue;
            return sdk2;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        return projectJdkTable.findJdk(sdkName, sdkType);
    }

    private ModuleJdkOrderEntryImpl(@NotNull ModuleJdkOrderEntryImpl that, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.init(that.myJdk, that.getJdkName(), that.getJdkType());
    }

    ModuleJdkOrderEntryImpl(String jdkName, String jdkType, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        super(rootModel, projectRootManager);
        this.init(null, jdkName, jdkType);
    }

    private void init(Sdk jdk, @Nullable String jdkName, String jdkType) {
        this.myJdk = jdk;
        this.myJdkName = jdkName;
        this.myJdkType = jdkType;
        this.myProjectRootManagerImpl.addJdkTableListener(this, this);
        this.init();
    }

    private String getJdkType() {
        if (this.myJdk != null) {
            return this.myJdk.getSdkType().getName();
        }
        return this.myJdkType;
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myJdk == null ? null : this.myJdk.getRootProvider();
    }

    @Nullable
    public Sdk getJdk() {
        return this.getRootModel().getConfigurationAccessor().getSdk(this.myJdk, this.myJdkName);
    }

    @Nullable
    public String getJdkName() {
        if (this.myJdkName != null) {
            return this.myJdkName;
        }
        Sdk jdk = this.getJdk();
        if (jdk != null) {
            return jdk.getName();
        }
        return null;
    }

    @Nullable
    public String getJdkTypeName() {
        if (this.myJdkType != null) {
            return this.myJdkType;
        }
        Sdk jdk = this.getJdk();
        if (jdk != null) {
            return jdk.getSdkType().getName();
        }
        return null;
    }

    public boolean isSynthetic() {
        return true;
    }

    @NotNull
    public String getPresentableName() {
        return "< " + (this.myJdk == null ? this.getJdkName() : this.myJdk.getName()) + " >";
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getJdk() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleJdkOrderEntry((ModuleJdkOrderEntry)this, initialValue);
    }

    public void jdkAdded(@NotNull Sdk jdk) {
        if (this.myJdk == null && jdk.getName().equals(this.getJdkName())) {
            this.myJdk = jdk;
            this.myJdkName = null;
            this.myJdkType = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
        if (this.myJdk == null && jdk.getName().equals(this.getJdkName())) {
            this.myJdk = jdk;
            this.myJdkName = null;
            this.myJdkType = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    public void jdkRemoved(@NotNull Sdk jdk) {
        if (jdk == this.myJdk) {
            this.myJdkName = this.myJdk.getName();
            this.myJdkType = this.myJdk.getSdkType().getName();
            this.myJdk = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        String jdkType;
        Element element2 = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String jdkName = this.getJdkName();
        if (jdkName != null) {
            element2.setAttribute(JDK_NAME_ATTR, jdkName);
        }
        if ((jdkType = this.getJdkType()) != null) {
            element2.setAttribute(JDK_TYPE_ATTR, jdkType);
        }
        rootElement.addContent(element2);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull ModifiableRootModel rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        return new ModuleJdkOrderEntryImpl(this, (RootModelImpl)rootModel, ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject()));
    }
}

