/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.ModelBranch;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    private final FileTypeRegistry myFileTypeRegistry;
    final DirectoryIndex myDirectoryIndex;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex) {
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContent(@NotNull ContentIterator processor2) {
        return this.iterateContent(processor2, null);
    }

    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, @NotNull ContentIterator processor2, final @Nullable VirtualFileFilter customFilter) {
        final ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor2);
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                ContentIteratorEx.Status status;
                DirectoryInfo info = (DirectoryInfo)ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file2));
                if (file2.isDirectory()) {
                    if (info.isExcluded(file2)) {
                        if (!info.processContentBeneathExcluded(file2, (Processor<? super VirtualFile>)((Processor)content2 -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content2, (ContentIterator)processorEx, customFilter)))) {
                            return 1.skipTo((VirtualFile)dir);
                        }
                        return SKIP_CHILDREN;
                    }
                    if (info.isIgnored()) {
                        return SKIP_CHILDREN;
                    }
                }
                boolean accepted = (Boolean)ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file2, info)) != false && (customFilter == null || customFilter.accept(file2));
                ContentIteratorEx.Status status2 = status = accepted ? processorEx.processFileEx(file2) : ContentIteratorEx.Status.CONTINUE;
                if (status == ContentIteratorEx.Status.CONTINUE) {
                    return CONTINUE;
                }
                if (status == ContentIteratorEx.Status.SKIP_CHILDREN) {
                    return SKIP_CHILDREN;
                }
                return 1.skipTo((VirtualFile)dir);
            }
        });
        return !Comparing.equal((Object)result2.skipToParent, (Object)dir);
    }

    @NotNull
    private static ContentIteratorEx toContentIteratorEx(@NotNull ContentIterator processor2) {
        if (processor2 instanceof ContentIteratorEx) {
            return (ContentIteratorEx)processor2;
        }
        return fileOrDir -> processor2.processFile(fileOrDir) ? ContentIteratorEx.Status.CONTINUE : ContentIteratorEx.Status.STOP;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        return this.iterateContentUnderDirectory(dir, processor2, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType = this.myDirectoryIndex.getSourceRootType(info);
        return rootType != null && rootType.isForTests();
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        ModelBranch branch;
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((branch = ModelBranch.getFileBranch((VirtualFile)(file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2)))) != null) {
            file2 = Objects.requireNonNull(branch.findOriginalFile(file2));
        }
        return this.myDirectoryIndex.getInfoForFile(file2);
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }
}

