/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Query;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public final class DirectoryIndexImpl
extends DirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project) {
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect();
        this.subscribeToFileChanges();
        LowMemoryWatcher.register(() -> {
            RootIndex index = this.myRootIndex;
            if (index != null) {
                index.onLowMemory();
            }
        }, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                RootIndex rootIndex = DirectoryIndexImpl.this.myRootIndex;
                if (rootIndex != null && DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    rootIndex.myPackageDirectoryCache.clear();
                    for (VFileEvent vFileEvent : events) {
                        if (!DirectoryIndexImpl.isIgnoredFileCreated(vFileEvent)) continue;
                        DirectoryIndexImpl.this.myRootIndex = null;
                        break;
                    }
                }
            }
        });
    }

    private static boolean shouldResetOnEvents(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (!(vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).isDirectory() : (file2 = vFileEvent.getFile()) == null || file2.isDirectory())) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredFileCreated(@NotNull VFileEvent event) {
        return event instanceof VFileMoveEvent && FileTypeRegistry.getInstance().isFileIgnored(((VFileMoveEvent)event).getNewParent()) || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileIgnored(((VFilePropertyChangeEvent)event).getFile());
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return this.getRootIndex().getDirectoriesByPackageName(packageName, includeLibrarySources);
    }

    @NotNull
    RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        return rootIndex;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file2 instanceof VirtualFileWithId)) {
            return NonProjectDirectoryInfo.NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION;
        }
        return this.getRootIndex().getInfoForFile(file2);
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder(@NotNull DirectoryInfo info) {
        boolean inModuleSource;
        boolean bl = inModuleSource = info instanceof DirectoryInfoImpl && ((DirectoryInfoImpl)info).isInModuleSource();
        if (inModuleSource) {
            return info.getSourceRootFolder();
        }
        return null;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        SourceFolder folder = this.getSourceRootFolder(info);
        return folder == null ? null : folder.getRootType();
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        this.checkAvailability();
        if (!(dir instanceof VirtualFileWithId)) {
            return null;
        }
        return this.getRootIndex().getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        this.checkAvailability();
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        return this.getRootIndex().getOrderEntries(info);
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module) {
        this.checkAvailability();
        return this.getRootIndex().getDependentUnloadedModules(module);
    }

    public void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i2 = 1; i2 < entries.size(); ++i2) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i2 - 1), entries.get(i2)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }
}

