/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableSyntheticLibrary
extends SyntheticLibrary {
    private final List<VirtualFile> mySourceRoots;
    private final List<VirtualFile> myBinaryRoots;
    private final Set<VirtualFile> myExcludedRoots;
    private final Condition<VirtualFile> myExcludeCondition;

    ImmutableSyntheticLibrary(@NotNull List<VirtualFile> sourceRoots, @NotNull List<VirtualFile> binaryRoots, @NotNull Set<VirtualFile> excludedRoots, @Nullable Condition<VirtualFile> excludeCondition) {
        this.mySourceRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(sourceRoots);
        this.myBinaryRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(binaryRoots);
        this.myExcludedRoots = ContainerUtil.unmodifiableOrEmptySet(excludedRoots);
        this.myExcludeCondition = excludeCondition;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        return this.mySourceRoots;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        return this.myBinaryRoots;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        return this.myExcludedRoots;
    }

    @Override
    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return this.myExcludeCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSyntheticLibrary library = (ImmutableSyntheticLibrary)o;
        if (!this.mySourceRoots.equals(library.getSourceRoots())) {
            return false;
        }
        if (!this.myBinaryRoots.equals(library.getBinaryRoots())) {
            return false;
        }
        if (!this.myExcludedRoots.equals(library.getExcludedRoots())) {
            return false;
        }
        return Objects.equals(this.myExcludeCondition, library.getExcludeFileCondition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mySourceRoots, this.myBinaryRoots, this.myExcludedRoots, this.myExcludeCondition);
    }

    @NotNull
    private static <E> List<E> immutableOrEmptyList(@NotNull List<? extends E> list2) {
        return list2.isEmpty() ? Collections.emptyList() : ContainerUtil.immutableList(list2);
    }
}

