/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SdkListCellRenderer
extends ColoredListCellRenderer<Sdk> {
    private final String myNullText;
    private final boolean myShowHomePath;

    public SdkListCellRenderer(@NotNull String nullText) {
        this(nullText, false);
    }

    public SdkListCellRenderer(@NotNull String nullText, boolean showHomePath) {
        this.myNullText = nullText;
        this.myShowHomePath = showHomePath;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list2, Sdk sdk2, int index, boolean selected2, boolean hasFocus) {
        if (sdk2 != null) {
            this.setIcon(this.getSdkIcon(sdk2));
            this.append(sdk2.getName());
            if (this.myShowHomePath) {
                this.append(" (" + FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)sdk2.getHomePath())) + ")", selected2 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.append(this.myNullText);
        }
    }

    protected Icon getSdkIcon(Sdk sdk2) {
        return ((SdkType)sdk2.getSdkType()).getIcon();
    }
}

