/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RootsAsVirtualFilePointers
implements RootProvider {
    private static final Logger LOG = Logger.getInstance(RootsAsVirtualFilePointers.class);
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots = new THashMap();
    private final boolean myNoCopyJars;
    private final VirtualFilePointerListener myListener;
    @NotNull
    private final Disposable myParent;

    RootsAsVirtualFilePointers(boolean noCopyJars, VirtualFilePointerListener listener2, @NotNull Disposable parent) {
        this.myNoCopyJars = noCopyJars;
        this.myListener = listener2;
        this.myParent = parent;
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        return container2 == null ? VirtualFile.EMPTY_ARRAY : container2.getFiles();
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        return container2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container2.getUrls();
    }

    public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType type) {
        this.getOrCreateContainer(type).add(virtualFile);
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType type) {
        this.getOrCreateContainer(type).add(url);
    }

    public void removeAllRoots(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        if (container2 != null) {
            container2.clear();
        }
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type) {
        this.removeRoot(root.getUrl(), type);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType type) {
        VirtualFilePointer pointer;
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        VirtualFilePointer virtualFilePointer = pointer = container2 == null ? null : container2.findByUrl(url);
        if (pointer != null) {
            container2.remove(pointer);
        }
    }

    public void removeAllRoots() {
        for (VirtualFilePointerContainer myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    public void readExternal(@NotNull Element element2) {
        for (PersistentOrderRootType type : OrderRootType.getAllPersistentTypes()) {
            this.read(element2, type);
        }
        ApplicationManager.getApplication().runReadAction(() -> this.myRoots.values().forEach(container2 -> {
            if (this.myNoCopyJars) {
                for (String root : container2.getUrls()) {
                    RootsAsVirtualFilePointers.setNoCopyJars(root);
                }
            }
        }));
    }

    public void writeExternal(@NotNull Element element2) {
        for (PersistentOrderRootType type : OrderRootType.getSortedRootTypes()) {
            this.write(element2, type);
        }
    }

    void copyRootsFrom(@NotNull RootProvider rootContainer) {
        this.removeAllRoots();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            String[] newRoots;
            for (String newRoot : newRoots = rootContainer.getUrls(rootType)) {
                this.addRoot(newRoot, rootType);
            }
        }
    }

    private static void setNoCopyJars(@NotNull String url) {
        if ("jar".equals(VirtualFileManager.extractProtocol((String)url))) {
            String path = VirtualFileManager.extractPath((String)url);
            VirtualFileSystem fileSystem = StandardFileSystems.jar();
            if (fileSystem instanceof JarCopyingFileSystem) {
                ((JarCopyingFileSystem)fileSystem).setNoCopyJarForPath(path);
            }
        }
    }

    private void read(@NotNull Element roots, @NotNull PersistentOrderRootType type) {
        Element composite;
        Element child2;
        String sdkRootName = type.getSdkRootName();
        Element element2 = child2 = sdkRootName == null ? null : roots.getChild(sdkRootName);
        if (child2 == null) {
            return;
        }
        List composites = child2.getChildren();
        if (composites.size() != 1) {
            LOG.error((Object)composites);
        }
        if (!(composite = (Element)composites.get(0)).getChildren("root").isEmpty()) {
            VirtualFilePointerContainer container2 = this.getOrCreateContainer((OrderRootType)type);
            container2.readExternal(composite, "root", false);
        }
    }

    private void write(@NotNull Element roots, @NotNull PersistentOrderRootType type) {
        String sdkRootName = type.getSdkRootName();
        if (sdkRootName == null) {
            return;
        }
        Element e = new Element(sdkRootName);
        roots.addContent(e);
        Element composite = new Element("root");
        composite.setAttribute("type", "composite");
        e.addContent(composite);
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        if (container2 != null) {
            container2.writeExternal(composite, "root", false);
        }
        for (Element root : composite.getChildren()) {
            root.setAttribute("type", "simple");
        }
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        throw new RuntimeException();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        throw new RuntimeException();
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        throw new RuntimeException();
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateContainer(@NotNull OrderRootType rootType) {
        VirtualFilePointerContainer roots = this.myRoots.get(rootType);
        if (roots == null) {
            roots = VirtualFilePointerManager.getInstance().createContainer(this.myParent, this.myListener);
            this.myRoots.put(rootType, roots);
        }
        return roots;
    }
}

