/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DumbServiceBalloon {
    private static final Logger LOG = Logger.getInstance(DumbServiceBalloon.class);
    @NotNull
    private static final JBInsets DUMB_BALLOON_INSETS = JBInsets.create((int)5, (int)8);
    private final Project myProject;
    private final Service myService;
    private Balloon myBalloon;

    public DumbServiceBalloon(@NotNull Project project, @NotNull Service service) {
        this.myProject = project;
        this.myService = service;
    }

    void dispose() {
        if (this.myBalloon != null) {
            Disposer.dispose((Disposable)this.myBalloon);
        }
    }

    void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonStillShowing) {
        if (LightEdit.owns((Project)this.myProject)) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myService.isDumb()) {
            UIEventLogger.logUIEvent((UIEventId)UIEventId.DumbModeBalloonWasNotNeeded, (FeatureUsageData)new FeatureUsageData().addProject(this.myProject));
            runWhenSmartAndBalloonStillShowing.run();
            return;
        }
        if (this.myBalloon != null) {
            return;
        }
        this.tryShowBalloonTillSmartMode(balloonText, runWhenSmartAndBalloonStillShowing);
    }

    private void tryShowBalloonTillSmartMode(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonNotHidden) {
        LOG.assertTrue(this.myBalloon == null);
        long startTimestamp = System.nanoTime();
        UIEventLogger.logUIEvent((UIEventId)UIEventId.DumbModeBalloonRequested, (FeatureUsageData)new FeatureUsageData().addProject(this.myProject));
        this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonText, AllIcons.General.BalloonWarning, UIUtil.getToolTipBackground(), null).setBorderColor(JBColor.border()).setBorderInsets((Insets)DUMB_BALLOON_INSETS).setShowCallout(false).createBalloon();
        this.myBalloon.setAnimationEnabled(false);
        this.myBalloon.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (DumbServiceBalloon.this.myBalloon == null) {
                    return;
                }
                FeatureUsageData data2 = new FeatureUsageData().addProject(DumbServiceBalloon.this.myProject);
                UIEventLogger.logUIEvent((UIEventId)UIEventId.DumbModeBalloonCancelled, (FeatureUsageData)data2);
                DumbServiceBalloon.this.myBalloon = null;
            }
        });
        this.myService.runWhenSmart(() -> {
            if (this.myBalloon == null) {
                return;
            }
            FeatureUsageData data2 = new FeatureUsageData().addProject(this.myProject).addData("duration_ms", TimeoutUtil.getDurationMillis((long)startTimestamp));
            UIEventLogger.logUIEvent((UIEventId)UIEventId.DumbModeBalloonProceededToActions, (FeatureUsageData)data2);
            runWhenSmartAndBalloonNotHidden.run();
            Balloon balloon = this.myBalloon;
            this.myBalloon = null;
            balloon.hide();
        });
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            if (!this.myService.isDumb()) {
                return;
            }
            if (this.myBalloon == null) {
                return;
            }
            UIEventLogger.logUIEvent((UIEventId)UIEventId.DumbModeBalloonShown, (FeatureUsageData)new FeatureUsageData().addProject(this.myProject));
            this.myBalloon.show(DumbServiceBalloon.getDumbBalloonPopupPoint(this.myBalloon, context), Balloon.Position.above);
        });
    }

    @NotNull
    private static RelativePoint getDumbBalloonPopupPoint(@NotNull Balloon balloon, DataContext context) {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
        Dimension size = balloon.getPreferredSize();
        Point point = relativePoint.getPoint();
        point.translate(size.width / 2, 0);
        point.translate(-DumbServiceBalloon.DUMB_BALLOON_INSETS.left - AllIcons.General.BalloonWarning.getIconWidth() - JBUIScale.scale((int)6), 0);
        return new RelativePoint(relativePoint.getComponent(), point);
    }

    static interface Service {
        public boolean isDumb();

        public void runWhenSmart(@NotNull Runnable var1);
    }
}

