/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class TooManyUsagesStatus {
    private static final Key<TooManyUsagesStatus> KEY = Key.create((String)"TooManyUsagesStatus");
    private static final NullStatus NULL_STATUS = new NullStatus();
    private final ProgressIndicator myIndicator;
    private final AtomicReference<Status> tooManyUsagesStatus = new AtomicReference<Status>(Status.FEW_USAGES);
    private final CountDownLatch waitWhileUserClick = new CountDownLatch(1);

    private TooManyUsagesStatus(@NotNull ProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    @NotNull
    public static TooManyUsagesStatus getFrom(@NotNull ProgressIndicator indicator) {
        TooManyUsagesStatus data2 = indicator instanceof UserDataHolder ? (TooManyUsagesStatus)((UserDataHolder)indicator).getUserData(KEY) : null;
        return data2 == null ? NULL_STATUS : data2;
    }

    public static TooManyUsagesStatus createFor(@NotNull ProgressIndicator indicator) {
        TooManyUsagesStatus data2 = null;
        if (indicator instanceof UserDataHolder) {
            data2 = new TooManyUsagesStatus(indicator);
            ((UserDataHolder)indicator).putUserData(KEY, (Object)data2);
        }
        return data2;
    }

    public boolean switchTooManyUsagesStatus() {
        return this.tooManyUsagesStatus.get() == Status.FEW_USAGES && this.tooManyUsagesStatus.compareAndSet(Status.FEW_USAGES, Status.WARNING_DIALOG_SHOWN);
    }

    public void userResponded() {
        this.waitWhileUserClick.countDown();
        this.tooManyUsagesStatus.set(Status.USER_RESPONDED);
    }

    public void pauseProcessingIfTooManyUsages() {
        if (this.tooManyUsagesStatus.get() == Status.WARNING_DIALOG_SHOWN) {
            long start2 = System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() < start2 + 2000L && !this.waitWhileUserClick.await(10L, TimeUnit.MILLISECONDS) && !this.myIndicator.isCanceled()) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class NullStatus
    extends TooManyUsagesStatus {
        private NullStatus() {
            super((ProgressIndicator)new EmptyProgressIndicator());
        }

        @Override
        public boolean switchTooManyUsagesStatus() {
            return false;
        }

        @Override
        public void userResponded() {
        }

        @Override
        public void pauseProcessingIfTooManyUsages() {
        }
    }

    public static enum Status {
        FEW_USAGES,
        WARNING_DIALOG_SHOWN,
        USER_RESPONDED;

    }
}

