/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction) {
        return BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, 300L, false);
    }

    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean forceEDT) {
        ModalityState modality = ModalityState.current();
        if (forceEDT) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback3 = (Runnable)ProgressManager.getInstance().runProcess(() -> BackgroundTaskUtil.lambda$executeAndTryWait$0(backgroundTask, (ProgressIndicator)indicator2), (ProgressIndicator)indicator2);
                BackgroundTaskUtil.finish(callback3, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback3) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            return indicator2;
        }
        Pair<? extends Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback2, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback2, indicator), modality), modality, waitMillis);
        Runnable callback4 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback4 != null) {
            BackgroundTaskUtil.finish(callback4, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        return indicator3;
    }

    private static void finish(@NotNull Runnable result2, @NotNull ProgressIndicator indicator) {
        if (!indicator.isCanceled()) {
            result2.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<? super ProgressIndicator, ? extends T> backgroundTask, long waitMillis) {
        Pair<? extends T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result2, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result3 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result3;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<? extends T> computable, @NotNull Consumer<? super T> asyncCallback, long waitMillis) {
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> computable.compute(), (result2, indicator) -> asyncCallback.consume(result2), ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    private static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends T> task2, @NotNull PairConsumer<? super T, ? super ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        indicator.start();
        Helper helper = new Helper();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$7(task2, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result2 = null;
        if (helper.await(waitMillis)) {
            result2 = helper.getResult();
        }
        return Pair.create(result2, (Object)indicator);
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Disposable parent, @NotNull Runnable runnable2) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        indicator.start();
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> BackgroundTaskUtil.lambda$executeOnPooledThread$8(runnable2, (ProgressIndicator)indicator), AppExecutorUtil.getAppExecutorService());
        Disposable disposable2 = () -> BackgroundTaskUtil.lambda$executeOnPooledThread$9((ProgressIndicator)indicator, future2, runnable2);
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable2)) {
            indicator.cancel();
            return indicator;
        }
        future2.whenComplete((o, e) -> Disposer.dispose((Disposable)disposable2));
        return indicator;
    }

    public static <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Supplier<T> task2) {
        Ref ref = new Ref();
        BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, () -> ref.set(task2.get()));
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Runnable task2) {
        ProgressIndicator threadProgress = ProgressManager.getInstance().getProgressIndicator();
        Object indicator = threadProgress == null ? new EmptyProgressIndicator(ModalityState.defaultModalityState()) : new SensitiveProgressWrapper(threadProgress);
        Disposable disposable2 = () -> BackgroundTaskUtil.lambda$runUnderDisposeAwareIndicator$12((ProgressIndicator)indicator);
        if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable2)) {
            indicator.cancel();
            throw new ProcessCanceledException();
        }
        try {
            ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)indicator);
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private static boolean registerIfParentNotDisposed(@NotNull Disposable parent, @NotNull Disposable disposable2) {
        if (parent instanceof ComponentManager && ((ComponentManager)parent).isDisposed()) {
            return false;
        }
        return Disposer.tryRegister((Disposable)parent, (Disposable)disposable2);
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Project project, @NotNull Topic<L> topic) throws ProcessCanceledException {
        return (L)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return project.getMessageBus().syncPublisher(topic);
        });
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Topic<L> topic) throws ProcessCanceledException {
        return (L)ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
        });
    }

    private static /* synthetic */ void lambda$runUnderDisposeAwareIndicator$12(ProgressIndicator indicator) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$9(ProgressIndicator indicator, CompletableFuture future2, Runnable runnable2) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
        try {
            future2.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof ProcessCanceledException)) {
                LOG.error((Throwable)e);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.debug("Couldn't await background process on disposal: " + runnable2);
        }
    }

    private static /* synthetic */ void lambda$executeOnPooledThread$8(Runnable runnable2, ProgressIndicator indicator) {
        ProgressManager.getInstance().runProcess(runnable2, indicator);
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$7(Function task2, ProgressIndicator indicator, Helper helper, PairConsumer asyncCallback) {
        ProgressManager.getInstance().runProcess(() -> {
            Object result2 = task2.fun((Object)indicator);
            if (!helper.setResult(result2)) {
                asyncCallback.consume(result2, (Object)indicator);
            }
        }, indicator);
    }

    private static /* synthetic */ Runnable lambda$executeAndTryWait$0(Function backgroundTask, ProgressIndicator indicator) {
        return (Runnable)backgroundTask.fun((Object)indicator);
    }

    private static class Helper<T> {
        private static final Object INITIAL_STATE = ObjectUtils.sentinel((String)"INITIAL_STATE");
        private static final Object SLOW_OPERATION_STATE = ObjectUtils.sentinel((String)"SLOW_OPERATION_STATE");
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result2) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result2);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result2 = this.myResultRef.get();
            assert (result2 != INITIAL_STATE && result2 != SLOW_OPERATION_STATE);
            return (T)result2;
        }
    }
}

