/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class OptionsEditorContext {
    CopyOnWriteArraySet<OptionsEditorColleague> myColleagues = new CopyOnWriteArraySet();
    Configurable myCurrentConfigurable;
    Set<Configurable> myModified = new CopyOnWriteArraySet<Configurable>();
    Map<Configurable, ConfigurationException> myErrors = new THashMap();
    private boolean myHoldingFilter;
    private final Map<Configurable, Configurable> myConfigurableToParentMap = new HashMap<Configurable, Configurable>();
    private final MultiMap<Configurable, Configurable> myParentToChildrenMap = new MultiMap();

    @NotNull
    Promise<? super Object> fireSelected(final @Nullable Configurable configurable2, @NotNull OptionsEditorColleague requestor) {
        if (this.myCurrentConfigurable == configurable2) {
            return Promises.rejectedPromise();
        }
        final Configurable old = this.myCurrentConfigurable;
        this.myCurrentConfigurable = configurable2;
        return this.notify(new ColleagueAction(){

            @Override
            @NotNull
            public Promise<? super Object> process(OptionsEditorColleague colleague) {
                return colleague.onSelected(configurable2, old);
            }
        }, requestor);
    }

    @NotNull
    Promise<? super Object> fireModifiedAdded(final @NotNull Configurable configurable2, @Nullable OptionsEditorColleague requestor) {
        if (this.myModified.contains(configurable2)) {
            return Promises.rejectedPromise();
        }
        this.myModified.add(configurable2);
        return this.notify(new ColleagueAction(){

            @Override
            @NotNull
            public Promise<? super Object> process(OptionsEditorColleague colleague) {
                return colleague.onModifiedAdded(configurable2);
            }
        }, requestor);
    }

    @NotNull
    Promise<? super Object> fireModifiedRemoved(final @NotNull Configurable configurable2, @Nullable OptionsEditorColleague requestor) {
        if (!this.myModified.contains(configurable2)) {
            return Promises.rejectedPromise();
        }
        this.myModified.remove(configurable2);
        return this.notify(new ColleagueAction(){

            @Override
            @NotNull
            public Promise<? super Object> process(OptionsEditorColleague colleague) {
                return colleague.onModifiedRemoved(configurable2);
            }
        }, requestor);
    }

    @NotNull
    Promise<? super Object> fireErrorsChanged(Map<Configurable, ConfigurationException> errors, OptionsEditorColleague requestor) {
        if (this.myErrors.equals(errors)) {
            return Promises.rejectedPromise();
        }
        this.myErrors = errors != null ? errors : new HashMap();
        return this.notify(new ColleagueAction(){

            @Override
            @NotNull
            public Promise<? super Object> process(OptionsEditorColleague colleague) {
                return colleague.onErrorsChanged();
            }
        }, requestor);
    }

    @NotNull
    Promise<? super Object> notify(@NotNull ColleagueAction action2, OptionsEditorColleague requestor) {
        return Promises.all((Collection)ContainerUtil.mapNotNull(this.myColleagues, it -> it == requestor ? null : action2.process((OptionsEditorColleague)it)));
    }

    public void fireReset(Configurable configurable2) {
        if (this.myModified.contains(configurable2)) {
            this.fireModifiedRemoved(configurable2, null);
        }
        if (this.myErrors.containsKey(configurable2)) {
            THashMap newErrors = new THashMap(this.myErrors);
            newErrors.remove(configurable2);
            this.fireErrorsChanged((Map<Configurable, ConfigurationException>)newErrors, null);
        }
    }

    public boolean isModified(Configurable configurable2) {
        return this.myModified.contains(configurable2);
    }

    public void setHoldingFilter(boolean holding) {
        this.myHoldingFilter = holding;
    }

    public boolean isHoldingFilter() {
        return this.myHoldingFilter;
    }

    public Configurable getParentConfigurable(Configurable configurable2) {
        return this.myConfigurableToParentMap.get(configurable2);
    }

    public void registerKid(Configurable parent, Configurable kid) {
        this.myConfigurableToParentMap.put(kid, parent);
        this.myParentToChildrenMap.putValue((Object)parent, (Object)kid);
    }

    @NotNull
    public Collection<Configurable> getChildren(Configurable parent) {
        return this.myParentToChildrenMap.get((Object)parent);
    }

    public Configurable getCurrentConfigurable() {
        return this.myCurrentConfigurable;
    }

    public Set<Configurable> getModified() {
        return Collections.unmodifiableSet(this.myModified);
    }

    public Map<Configurable, ConfigurationException> getErrors() {
        return this.myErrors;
    }

    public void addColleague(@NotNull OptionsEditorColleague colleague) {
        this.myColleagues.add(colleague);
    }

    public void reload() {
        this.myCurrentConfigurable = null;
        this.myErrors.clear();
        this.myConfigurableToParentMap.clear();
        this.myParentToChildrenMap.clear();
    }

    static interface ColleagueAction {
        @NotNull
        public Promise<? super Object> process(OptionsEditorColleague var1);
    }
}

