/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class IgnoredFileCache {
    private final ConcurrentBitSet myNonIgnoredIds = new ConcurrentBitSet();
    private final IgnoredPatternSet myIgnoredPatterns;
    private int myVfsEventNesting;

    IgnoredFileCache(@NotNull IgnoredPatternSet ignoredPatterns) {
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                IgnoredFileCache.this.myVfsEventNesting++;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                this.clearCacheForChangedFiles(events);
                IgnoredFileCache.this.myVfsEventNesting--;
            }

            private void clearCacheForChangedFiles(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename() || !((file2 = vFileEvent.getFile()) instanceof NewVirtualFile)) continue;
                    int id2 = ((NewVirtualFile)file2).getId();
                    IgnoredFileCache.this.myNonIgnoredIds.clear(id2);
                }
            }
        });
    }

    void clearCache() {
        this.myNonIgnoredIds.clear();
    }

    boolean isFileIgnored(@NotNull VirtualFile file2) {
        boolean idable;
        boolean bl = idable = this.myVfsEventNesting == 0 && file2 instanceof NewVirtualFile;
        if (!idable) {
            return this.calcIgnored(file2);
        }
        int id2 = ((NewVirtualFile)file2).getId();
        if (this.myNonIgnoredIds.get(id2)) {
            return false;
        }
        return this.calcAndCache(file2, id2);
    }

    private boolean calcAndCache(VirtualFile file2, int id2) {
        boolean result2 = this.calcIgnored(file2);
        if (!result2) {
            this.myNonIgnoredIds.set(id2);
        }
        return result2;
    }

    private boolean calcIgnored(VirtualFile file2) {
        return this.myIgnoredPatterns.isIgnored(file2.getNameSequence());
    }
}

