/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.focusMode.FocusModePassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAwareTextEditorImpl
extends TextEditorImpl {
    private TextEditorBackgroundHighlighter myBackgroundHighlighter;

    public PsiAwareTextEditorImpl(@NotNull Project project, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider) {
        super(project, file2, provider);
    }

    @Override
    @NotNull
    protected Runnable loadEditorInBackground() {
        Runnable baseResult = super.loadEditorInBackground();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        boolean shouldBuildInitialFoldings = document != null && !this.myProject.isDefault() && PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(document);
        CodeFoldingState foldingState = shouldBuildInitialFoldings ? CodeFoldingManager.getInstance(this.myProject).buildInitialFoldings(document) : null;
        List<? extends Segment> focusZones = FocusModePassFactory.calcFocusZones(psiFile);
        Editor editor = this.getEditor();
        DocRenderPassFactory.Items items = document != null && psiFile != null && DocRenderManager.isDocRenderingEnabled(this.getEditor()) ? DocRenderPassFactory.calculateItemsToRender(editor, psiFile) : null;
        return () -> {
            baseResult.run();
            if (foldingState != null) {
                foldingState.setToEditor(editor);
            }
            if (focusZones != null) {
                FocusModePassFactory.setToEditor(focusZones, editor);
                if (editor instanceof EditorImpl) {
                    ((EditorImpl)editor).applyFocusMode();
                }
            }
            if (items != null) {
                DocRenderPassFactory.applyItemsToRender(editor, this.myProject, items, true);
            }
            if (psiFile != null && psiFile.isValid()) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
            }
        };
    }

    @Override
    @NotNull
    protected TextEditorComponent createEditorComponent(@NotNull Project project, @NotNull VirtualFile file2) {
        return new PsiAwareTextEditorComponent(project, file2, this);
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (!AsyncEditorLoader.isEditorLoaded(this.getEditor())) {
            return null;
        }
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new TextEditorBackgroundHighlighter(this.myProject, this.getEditor());
        }
        return this.myBackgroundHighlighter;
    }

    private static class PsiAwareTextEditorComponent
    extends TextEditorComponent {
        private final Project myProject;
        private final VirtualFile myFile;

        private PsiAwareTextEditorComponent(@NotNull Project project, @NotNull VirtualFile file2, @NotNull TextEditorImpl textEditor) {
            super(project, file2, textEditor);
            this.myProject = project;
            this.myFile = file2;
        }

        @Override
        public void dispose() {
            super.dispose();
            CodeFoldingManager foldingManager = (CodeFoldingManager)this.myProject.getServiceIfCreated(CodeFoldingManager.class);
            if (foldingManager != null) {
                foldingManager.releaseFoldings(this.getEditor());
            }
        }

        @Override
        @Nullable
        public DataProvider createBackgroundDataProvider() {
            DataProvider superProvider = super.createBackgroundDataProvider();
            if (superProvider == null) {
                return null;
            }
            return dataId -> {
                LookupImpl lookup2;
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId) && (lookup2 = (LookupImpl)LookupManager.getInstance(this.myProject).getActiveLookup()) != null && lookup2.isVisible()) {
                    return lookup2.getBounds();
                }
                if (LangDataKeys.MODULE.is(dataId)) {
                    return ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
                }
                return superProvider.getData(dataId);
            };
        }
    }
}

